/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.equations.AbstractShuntCompensatorEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfShunt;
import java.util.List;
import java.util.Objects;

public class ShuntCompensatorReactiveFlowEquationTerm
extends AbstractShuntCompensatorEquationTerm {
    private Variable<AcVariableType> bVar;
    private final List<Variable<AcVariableType>> variables;

    public ShuntCompensatorReactiveFlowEquationTerm(LfShunt shunt, LfBus bus, VariableSet<AcVariableType> variableSet, boolean deriveB) {
        super(shunt, bus, variableSet);
        if (deriveB) {
            this.bVar = variableSet.getVariable(shunt.getNum(), AcVariableType.SHUNT_B);
            this.variables = List.of(this.vVar, this.bVar);
        } else {
            this.variables = List.of(this.vVar);
        }
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    private double b() {
        return this.bVar != null ? this.sv.get(this.bVar.getRow()) : ((LfShunt)this.element).getB();
    }

    public static double q(double v, double b) {
        return -b * v * v;
    }

    public static double dqdv(double v, double b) {
        return -2.0 * b * v;
    }

    public static double dqdb(double v) {
        return -v * v;
    }

    @Override
    public double eval() {
        return ShuntCompensatorReactiveFlowEquationTerm.q(this.v(), this.b());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.vVar)) {
            return ShuntCompensatorReactiveFlowEquationTerm.dqdv(this.v(), this.b());
        }
        if (variable.equals(this.bVar)) {
            return ShuntCompensatorReactiveFlowEquationTerm.dqdb(this.v());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    public static double calculateSensi(double v, double b, double dv, double db) {
        return ShuntCompensatorReactiveFlowEquationTerm.dqdv(v, b) * dv + ShuntCompensatorReactiveFlowEquationTerm.dqdb(v) * db;
    }

    @Override
    public double calculateSensi(DenseMatrix dx, int column) {
        double dv = dx.get(this.vVar.getRow(), column);
        double db = this.bVar != null ? dx.get(this.bVar.getRow(), column) : 0.0;
        double v = this.v();
        double b = this.b();
        return ShuntCompensatorReactiveFlowEquationTerm.calculateSensi(v, b, dv, db);
    }

    @Override
    protected String getName() {
        return "ac_q_shunt";
    }
}

