/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;

public abstract class AbstractShuntFortescueEquationTerm
extends AbstractElementEquationTerm<LfBus, AcVariableType, AcEquationType> {
    protected final Variable<AcVariableType> vVar;
    protected final Variable<AcVariableType> phVar;
    protected final Fortescue.SequenceType sequenceType;

    protected AbstractShuntFortescueEquationTerm(LfBus bus, VariableSet<AcVariableType> variableSet, Fortescue.SequenceType sequenceType) {
        super(bus);
        AcVariableType vType;
        Objects.requireNonNull(variableSet);
        this.sequenceType = Objects.requireNonNull(sequenceType);
        AcVariableType phType = switch (sequenceType) {
            case Fortescue.SequenceType.ZERO -> {
                vType = AcVariableType.BUS_V_ZERO;
                yield AcVariableType.BUS_PHI_ZERO;
            }
            case Fortescue.SequenceType.NEGATIVE -> {
                vType = AcVariableType.BUS_V_NEGATIVE;
                yield AcVariableType.BUS_PHI_NEGATIVE;
            }
            default -> throw new IllegalStateException("Unknown or unadapted sequence type " + sequenceType);
        };
        this.vVar = variableSet.getVariable(bus.getNum(), vType);
        this.phVar = variableSet.getVariable(bus.getNum(), phType);
    }

    protected double v() {
        return this.sv.get(this.vVar.getRow());
    }

    protected double ph() {
        return this.sv.get(this.phVar.getRow());
    }

    protected double b() {
        return this.sequenceType == Fortescue.SequenceType.ZERO ? ((LfBus)this.element).getAsym().getBzEquiv() : ((LfBus)this.element).getAsym().getBnEquiv();
    }

    protected double g() {
        return this.sequenceType == Fortescue.SequenceType.ZERO ? ((LfBus)this.element).getAsym().getGzEquiv() : ((LfBus)this.element).getAsym().getGnEquiv();
    }
}

