/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.ComplexPart;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class AsymmetricalClosedBranchCoupledCurrentEquationTerm
extends AbstractAsymmetricalClosedBranchCoupledFlowEquationTerm {
    public AsymmetricalClosedBranchCoupledCurrentEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, ComplexPart complexPart, TwoSides side, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, complexPart, side, sequenceType);
    }

    public double ix(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.r(i) * this.r(j) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))));
    }

    public double iy(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h) {
        return this.r(i) * this.r(j) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))));
    }

    public double dixdv(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * (this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))));
        }
        return 0.0;
    }

    public double dixdph(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(h, j) * (-this.y.getX(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))));
        }
        return 0.0;
    }

    public double dix(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence, boolean phase) {
        if (phase) {
            return this.dixdph(i, j, g, h, derivationSide, derivationSequence);
        }
        return this.dixdv(i, j, g, h, derivationSide, derivationSequence);
    }

    public double diydv(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * (this.y.getX(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))) + this.y.getY(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))));
        }
        return 0.0;
    }

    public double diydph(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence) {
        if (j == derivationSide && h == derivationSequence) {
            return this.r(i) * this.r(j) * this.v(h, j) * (this.y.getX(i, j, g, h) * FastMath.cos((double)(this.a(j) - this.a(i) + this.ph(h, j))) - this.y.getY(i, j, g, h) * FastMath.sin((double)(this.a(j) - this.a(i) + this.ph(h, j))));
        }
        return 0.0;
    }

    public double diy(TwoSides i, TwoSides j, Fortescue.SequenceType g, Fortescue.SequenceType h, TwoSides derivationSide, Fortescue.SequenceType derivationSequence, boolean phase) {
        if (phase) {
            return this.diydph(i, j, g, h, derivationSide, derivationSequence);
        }
        return this.diydv(i, j, g, h, derivationSide, derivationSequence);
    }

    public double di(Variable<AcVariableType> variable) {
        TwoSides j;
        TwoSides i;
        if (this.side == TwoSides.ONE) {
            i = TwoSides.ONE;
            j = TwoSides.TWO;
        } else {
            i = TwoSides.TWO;
            j = TwoSides.ONE;
        }
        TwoSides derivationSide = this.getSide(variable);
        Fortescue.SequenceType derivationSequence = AsymmetricalClosedBranchCoupledCurrentEquationTerm.getSequenceType(variable);
        boolean phase = AsymmetricalClosedBranchCoupledCurrentEquationTerm.isPhase(variable);
        if (this.complexPart == ComplexPart.REAL) {
            return this.dix(i, i, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dix(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dix(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase) + this.dix(i, j, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.dix(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.dix(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase);
        }
        return this.diy(i, i, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.diy(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.diy(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase) + this.diy(i, j, this.sequenceType, Fortescue.SequenceType.ZERO, derivationSide, derivationSequence, phase) + this.diy(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE, derivationSide, derivationSequence, phase) + this.diy(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE, derivationSide, derivationSequence, phase);
    }

    public double i() {
        TwoSides j;
        TwoSides i;
        if (this.side == TwoSides.ONE) {
            i = TwoSides.ONE;
            j = TwoSides.TWO;
        } else {
            i = TwoSides.TWO;
            j = TwoSides.ONE;
        }
        if (this.complexPart == ComplexPart.REAL) {
            return this.ix(i, i, this.sequenceType, Fortescue.SequenceType.ZERO) + this.ix(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.ix(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE) + this.ix(i, j, this.sequenceType, Fortescue.SequenceType.ZERO) + this.ix(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.ix(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE);
        }
        return this.iy(i, i, this.sequenceType, Fortescue.SequenceType.ZERO) + this.iy(i, i, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.iy(i, i, this.sequenceType, Fortescue.SequenceType.NEGATIVE) + this.iy(i, j, this.sequenceType, Fortescue.SequenceType.ZERO) + this.iy(i, j, this.sequenceType, Fortescue.SequenceType.POSITIVE) + this.iy(i, j, this.sequenceType, Fortescue.SequenceType.NEGATIVE);
    }

    @Override
    public double eval() {
        return this.i();
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        return this.di(variable);
    }

    @Override
    public String getName() {
        return "ac_ixiy_coupled_closed";
    }
}

