/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations.asym;

import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AbstractShuntFortescueCurrentEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ShuntFortescueIxEquationTerm
extends AbstractShuntFortescueCurrentEquationTerm {
    public ShuntFortescueIxEquationTerm(LfBus bus, VariableSet<AcVariableType> variableSet, Fortescue.SequenceType sequenceType) {
        super(bus, variableSet, sequenceType);
    }

    private static double ix(double v, double phi, double g, double b) {
        return g * v * FastMath.cos((double)phi) - b * v * FastMath.sin((double)phi);
    }

    private static double dixdv(double phi, double g, double b) {
        return g * FastMath.cos((double)phi) - b * FastMath.sin((double)phi);
    }

    private static double dixdph(double v, double phi, double g, double b) {
        return -g * v * FastMath.sin((double)phi) - b * v * FastMath.cos((double)phi);
    }

    @Override
    public double eval() {
        return ShuntFortescueIxEquationTerm.ix(this.v(), this.ph(), this.g(), this.b());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.vVar)) {
            return ShuntFortescueIxEquationTerm.dixdv(this.ph(), this.g(), this.b());
        }
        if (variable.equals(this.phVar)) {
            return ShuntFortescueIxEquationTerm.dixdph(this.v(), this.ph(), this.g(), this.b());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    public String getName() {
        return "ac_ix_fortescue_shunt";
    }
}

