/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransformerVoltageControlOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransformerVoltageControlOuterLoop.class);
    private static final double MIN_TARGET_DEADBAND_KV = 0.1;
    private static final String TYPE = "TransformerVoltageControl";

    @Override
    public String getType() {
        return TYPE;
    }

    protected OuterLoopStatus roundVoltageRatios(LfNetwork network) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        for (LfBranch controllerBranch : network.getControllerElements(VoltageControl.Type.TRANSFORMER)) {
            controllerBranch.setVoltageControlEnabled(false);
            PiModel piModel = controllerBranch.getPiModel();
            double r1Value = piModel.getR1();
            piModel.roundR1ToClosestTap();
            double roundedR1Value = piModel.getR1();
            LOGGER.trace("Round voltage ratio of '{}': {} -> {}", new Object[]{controllerBranch.getId(), r1Value, roundedR1Value});
            status = OuterLoopStatus.UNSTABLE;
        }
        return status;
    }

    protected static double getHalfTargetDeadband(TransformerVoltageControl voltageControl) {
        return voltageControl.getTargetDeadband().orElse(0.1 / voltageControl.getControlledBus().getNominalV()) / 2.0;
    }
}

