/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.AbstractIncrementalPhaseControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.LoggerFactory;

public class AcIncrementalPhaseControlOuterLoop
extends AbstractIncrementalPhaseControlOuterLoop<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowContext, AcOuterLoopContext>
implements AcOuterLoop {
    public AcIncrementalPhaseControlOuterLoop() {
        super(LoggerFactory.getLogger(AcIncrementalPhaseControlOuterLoop.class));
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        IncrementalContextData contextData = new IncrementalContextData();
        context.setData(contextData);
        List<LfBranch> controllerBranches = AcIncrementalPhaseControlOuterLoop.getControllerBranches(context.getNetwork());
        for (LfBranch controllerBranch : controllerBranches) {
            contextData.getControllersContexts().put(controllerBranch.getId(), new IncrementalContextData.ControllerContext(3));
        }
        AcIncrementalPhaseControlOuterLoop.fixPhaseShifterNecessaryForConnectivity(context.getNetwork(), controllerBranches);
    }

    private int checkCurrentLimiterPhaseControls(AcSensitivityContext sensitivityContext, IncrementalContextData contextData, List<TransformerPhaseControl> currentLimiterPhaseControls) {
        MutableInt numOfCurrentLimiterPstsThatChangedTap = new MutableInt(0);
        for (TransformerPhaseControl phaseControl : currentLimiterPhaseControls) {
            LfBranch controllerBranch = phaseControl.getControllerBranch();
            LfBranch controlledBranch = phaseControl.getControlledBranch();
            double i = AcIncrementalPhaseControlOuterLoop.computeI(phaseControl);
            if (!(i > phaseControl.getTargetValue())) continue;
            IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controllerBranch.getId());
            double di = phaseControl.getTargetValue() - i;
            double a2i = sensitivityContext.calculateSensitivityFromA2I(controllerBranch, controlledBranch, phaseControl.getControlledSide());
            if (!(Math.abs(a2i) > 1.0E-6)) continue;
            double da = Math.toRadians(di / a2i);
            double ib = AcIncrementalPhaseControlOuterLoop.computeIb(phaseControl);
            this.logger.trace("Controlled branch '{}' current is {} A and above target value {} A, a phase shift of {}\u00b0 is required", new Object[]{controlledBranch.getId(), i * ib, phaseControl.getTargetValue() * ib, Math.toDegrees(da)});
            PiModel piModel = controllerBranch.getPiModel();
            int oldTapPosition = piModel.getTapPosition();
            double oldA1 = piModel.getA1();
            Range<Integer> tapPositionRange = piModel.getTapPositionRange();
            piModel.updateTapPositionToExceedNewA1(da, Integer.MAX_VALUE, controllerContext.getAllowedDirection()).ifPresent(direction -> {
                controllerContext.updateAllowedDirection((Direction)((Object)direction));
                numOfCurrentLimiterPstsThatChangedTap.add(1);
            });
            if (piModel.getTapPosition() == oldTapPosition) continue;
            this.logger.debug("Controller branch '{}' changed tap from {} to {} to limit current (full range: {})", new Object[]{controllerBranch.getId(), oldTapPosition, piModel.getTapPosition(), tapPositionRange});
            double discreteDa = piModel.getA1() - oldA1;
            this.checkImpactOnOtherPhaseShifters(sensitivityContext, phaseControl, currentLimiterPhaseControls, discreteDa);
        }
        return numOfCurrentLimiterPstsThatChangedTap.getValue();
    }

    private void checkImpactOnOtherPhaseShifters(AcSensitivityContext sensitivityContext, TransformerPhaseControl phaseControl, List<TransformerPhaseControl> currentLimiterPhaseControls, double da) {
        LfBranch controllerBranch = phaseControl.getControllerBranch();
        for (TransformerPhaseControl otherPhaseControl : currentLimiterPhaseControls) {
            if (otherPhaseControl == phaseControl) continue;
            LfBranch otherControlledBranch = otherPhaseControl.getControlledBranch();
            double i = AcIncrementalPhaseControlOuterLoop.computeI(otherPhaseControl);
            if (!(i > otherPhaseControl.getTargetValue())) continue;
            double crossA2i = sensitivityContext.calculateSensitivityFromA2I(controllerBranch, otherControlledBranch, otherPhaseControl.getControlledSide());
            double ib = AcIncrementalPhaseControlOuterLoop.computeIb(otherPhaseControl);
            double di = Math.toDegrees(da) * crossA2i;
            if (!(di > 0.75 * (i - otherPhaseControl.getTargetValue()))) continue;
            this.logger.warn("Controller branch '{}' tap change significantly impact (\u2248 {} A) another phase shifter current also above its limit '{}', simulation might not be reliable", new Object[]{controllerBranch.getId(), di * ib, otherPhaseControl.getControlledBranch().getId()});
        }
    }

    private static double computeIb(TransformerPhaseControl phaseControl) {
        LfBus bus = phaseControl.getControlledSide() == TwoSides.ONE ? phaseControl.getControlledBranch().getBus1() : phaseControl.getControlledBranch().getBus2();
        return PerUnit.ib(bus.getNominalV());
    }

    private static double computeI(TransformerPhaseControl phaseControl) {
        Evaluable i = phaseControl.getControlledSide() == TwoSides.ONE ? phaseControl.getControlledBranch().getI1() : phaseControl.getControlledBranch().getI2();
        return i.eval();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        int numOfActivePowerControlPstsThatChangedTap;
        IncrementalContextData contextData = (IncrementalContextData)context.getData();
        LfNetwork network = context.getNetwork();
        List<LfBranch> controllerBranches = AcIncrementalPhaseControlOuterLoop.getControllerBranches(network);
        ArrayList<TransformerPhaseControl> activePowerControlPhaseControls = new ArrayList<TransformerPhaseControl>();
        ArrayList<TransformerPhaseControl> currentLimiterPhaseControls = new ArrayList<TransformerPhaseControl>();
        for (LfBranch controllerBranch : controllerBranches) {
            controllerBranch.getPhaseControl().ifPresent(phaseControl -> {
                switch (phaseControl.getMode()) {
                    case CONTROLLER: {
                        activePowerControlPhaseControls.add((TransformerPhaseControl)phaseControl);
                        break;
                    }
                    case LIMITER: {
                        currentLimiterPhaseControls.add((TransformerPhaseControl)phaseControl);
                        break;
                    }
                }
            });
        }
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        if (currentLimiterPhaseControls.isEmpty() && activePowerControlPhaseControls.isEmpty()) {
            return new OuterLoopResult(this, status);
        }
        AcSensitivityContext sensitivityContext = new AcSensitivityContext(network, controllerBranches, ((AcLoadFlowContext)context.getLoadFlowContext()).getEquationSystem(), ((AcLoadFlowContext)context.getLoadFlowContext()).getJacobianMatrix());
        int numOfCurrentLimiterPstsThatChangedTap = !currentLimiterPhaseControls.isEmpty() ? this.checkCurrentLimiterPhaseControls(sensitivityContext, contextData, currentLimiterPhaseControls) : 0;
        if (numOfCurrentLimiterPstsThatChangedTap + (numOfActivePowerControlPstsThatChangedTap = !activePowerControlPhaseControls.isEmpty() ? this.checkActivePowerControlPhaseControls(sensitivityContext, contextData, activePowerControlPhaseControls) : 0) != 0) {
            status = OuterLoopStatus.UNSTABLE;
            ReportNode iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
            if (numOfCurrentLimiterPstsThatChangedTap != 0) {
                Reports.reportCurrentLimiterPstsChangedTaps(iterationReportNode, numOfCurrentLimiterPstsThatChangedTap);
            }
            if (numOfActivePowerControlPstsThatChangedTap != 0) {
                Reports.reportActivePowerControlPstsChangedTaps(iterationReportNode, numOfActivePowerControlPstsThatChangedTap);
            }
        }
        return new OuterLoopResult(this, status);
    }

    public static class AcSensitivityContext
    extends AbstractIncrementalPhaseControlOuterLoop.AbstractSensitivityContext<AcVariableType, AcEquationType> {
        public AcSensitivityContext(LfNetwork network, List<LfBranch> controllerBranches, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> jacobianMatrix) {
            super(network, controllerBranches, equationSystem, jacobianMatrix);
        }

        @Override
        public DenseMatrix calculateSensitivityValues(List<LfBranch> controllerBranches, int[] controllerBranchIndex, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> jacobianMatrix) {
            DenseMatrix rhs = new DenseMatrix(equationSystem.getIndex().getSortedEquationsToSolve().size(), controllerBranches.size());
            for (LfBranch controllerBranch : controllerBranches) {
                equationSystem.getEquation(controllerBranch.getNum(), AcEquationType.BRANCH_TARGET_ALPHA1).ifPresent(equation -> rhs.set(equation.getColumn(), controllerBranchIndex[controllerBranch.getNum()], Math.toRadians(1.0)));
            }
            jacobianMatrix.solveTransposed(rhs);
            return rhs;
        }

        private EquationTerm<AcVariableType, AcEquationType> getI1(LfBranch controlledBranch) {
            return (EquationTerm)controlledBranch.getI1();
        }

        private EquationTerm<AcVariableType, AcEquationType> getI2(LfBranch controlledBranch) {
            return (EquationTerm)controlledBranch.getI2();
        }

        public double calculateSensitivityFromA2I(LfBranch controllerBranch, LfBranch controlledBranch, TwoSides controlledSide) {
            EquationTerm<AcVariableType, AcEquationType> i = controlledSide == TwoSides.ONE ? this.getI1(controlledBranch) : this.getI2(controlledBranch);
            return this.calculateSensitivityFromA2S(controllerBranch, i);
        }
    }
}

