/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfOverloadManagementSystem;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationSystemOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomationSystemOuterLoop.class);
    public static final String NAME = "AutomationSystem";

    @Override
    public String getName() {
        return NAME;
    }

    private boolean isInService(LfBranch branch) {
        return !branch.isDisabled() && branch.isConnectedAtBothSides();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        LfNetwork network = context.getNetwork();
        HashSet<LfBranch> branchesToOpen = new HashSet<LfBranch>();
        HashSet<LfBranch> branchesToClose = new HashSet<LfBranch>();
        block0: for (LfOverloadManagementSystem system : network.getOverloadManagementSystems()) {
            LfBranch branchToMonitor = system.getMonitoredBranch();
            if (!branchToMonitor.isConnectedAtBothSides()) continue;
            double i = system.getMonitoredSide() == TwoSides.ONE ? branchToMonitor.getI1().eval() : branchToMonitor.getI2().eval();
            for (LfOverloadManagementSystem.LfBranchTripping branchTripping : system.getBranchTrippingList()) {
                double threshold = branchTripping.threshold();
                LfBranch branchToOperate = branchTripping.branchToOperate();
                if (!(i > threshold) || branchTripping.branchOpen() == branchToOperate.isDisabled()) continue;
                double ib = PerUnit.ib((system.getMonitoredSide() == TwoSides.ONE ? branchToMonitor.getBus1() : branchToMonitor.getBus2()).getNominalV());
                if (branchTripping.branchOpen() && this.isInService(branchToOperate)) {
                    LOGGER.debug("Branch '{}' is overloaded ({} A > {} A), open branch at both side '{}'", new Object[]{branchToMonitor.getId(), i * ib, threshold * ib, branchToOperate.getId()});
                    branchesToOpen.add(branchToOperate);
                    continue block0;
                }
                if (branchTripping.branchOpen() || this.isInService(branchToOperate)) continue;
                LOGGER.debug("Branch '{}' is overloaded ({} A > {} A), close branch at both side '{}'", new Object[]{branchToMonitor.getId(), i * ib, threshold * ib, branchToOperate.getId()});
                branchesToClose.add(branchToOperate);
                continue block0;
            }
        }
        if (branchesToOpen.size() + branchesToClose.size() > 0) {
            network.getConnectivity().startTemporaryChanges();
            GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
            branchesToOpen.forEach(connectivity::removeEdge);
            branchesToClose.forEach(branch -> connectivity.addEdge(branch.getBus1(), branch.getBus2(), (LfBranch)branch));
            AbstractLfBranchAction.updateBusesAndBranchStatus(connectivity);
            network.getConnectivity().undoTemporaryChanges();
            branchesToOpen.forEach(connectivity::removeEdge);
            branchesToClose.forEach(branch -> connectivity.addEdge(branch.getBus1(), branch.getBus2(), (LfBranch)branch));
            status = OuterLoopStatus.UNSTABLE;
        }
        return new OuterLoopResult(this, status);
    }
}

