/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AcActivePowerDistributionOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.AbstractActivePowerDistributionOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.DistributedSlackContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.util.Reports;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSlackOuterLoop
extends AbstractActivePowerDistributionOuterLoop<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowContext, AcOuterLoopContext>
implements AcOuterLoop,
AcActivePowerDistributionOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedSlackOuterLoop.class);
    public static final String NAME = "DistributedSlack";
    private final double slackBusPMaxMismatch;
    private final ActivePowerDistribution activePowerDistribution;

    public DistributedSlackOuterLoop(ActivePowerDistribution activePowerDistribution, double slackBusPMaxMismatch) {
        this.activePowerDistribution = Objects.requireNonNull(activePowerDistribution);
        this.slackBusPMaxMismatch = slackBusPMaxMismatch;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        DistributedSlackContextData contextData = new DistributedSlackContextData();
        context.setData(contextData);
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        boolean shouldDistributeSlack;
        double slackBusActivePowerMismatch = this.getSlackBusActivePowerMismatch(context);
        double absMismatch = Math.abs(slackBusActivePowerMismatch);
        boolean bl = shouldDistributeSlack = absMismatch > this.slackBusPMaxMismatch / 100.0 && absMismatch > ActivePowerDistribution.P_RESIDUE_EPS;
        if (!shouldDistributeSlack) {
            LOGGER.debug("Already balanced");
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
        ReportNode iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
        ActivePowerDistribution.Result result = this.activePowerDistribution.run(context.getNetwork(), slackBusActivePowerMismatch);
        ActivePowerDistribution.ResultWithFailureBehaviorHandling resultWbh = ActivePowerDistribution.handleDistributionFailureBehavior(((AcLoadFlowParameters)((AcLoadFlowContext)context.getLoadFlowContext()).getParameters()).getSlackDistributionFailureBehavior(), context.getNetwork().getReferenceGenerator(), slackBusActivePowerMismatch, result, "Failed to distribute slack bus active power mismatch, %.2f MW remains");
        double remainingMismatch = resultWbh.remainingMismatch();
        double distributedActivePower = slackBusActivePowerMismatch - remainingMismatch;
        if (Math.abs(remainingMismatch) > this.slackBusPMaxMismatch / 100.0) {
            Reports.reportMismatchDistributionFailure(iterationReportNode, remainingMismatch * 100.0);
        } else {
            if (Math.abs(remainingMismatch) > ActivePowerDistribution.P_RESIDUE_EPS) {
                Reports.reportResidualDistributionMismatch(reportNode, remainingMismatch * 100.0);
            }
            ActivePowerDistribution.reportAndLogSuccess(iterationReportNode, slackBusActivePowerMismatch, resultWbh);
        }
        DistributedSlackContextData contextData = (DistributedSlackContextData)context.getData();
        contextData.addDistributedActivePower(distributedActivePower);
        if (resultWbh.failed()) {
            contextData.addDistributedActivePower(-resultWbh.failedDistributedActivePower());
            return new OuterLoopResult(this, OuterLoopStatus.FAILED, resultWbh.failedMessage());
        }
        return new OuterLoopResult(this, resultWbh.movedBuses() ? OuterLoopStatus.UNSTABLE : OuterLoopStatus.STABLE);
    }

    @Override
    public double getSlackBusActivePowerMismatch(AcOuterLoopContext context) {
        return context.getLastSolverResult().getSlackBusActivePowerMismatch();
    }
}

