/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AbstractShuntVoltageControlOuterLoop;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Reports;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalShuntVoltageControlOuterLoop
extends AbstractShuntVoltageControlOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalShuntVoltageControlOuterLoop.class);
    public static final String NAME = "IncrementalShuntVoltageControl";
    private static final int MAX_DIRECTION_CHANGE = 3;
    private static final double MIN_TARGET_DEADBAND_KV = 0.1;

    @Override
    public String getName() {
        return NAME;
    }

    public static List<LfBus> getControlledBusesOutOfDeadband(IncrementalContextData contextData) {
        return IncrementalContextData.getControlledBuses(contextData.getCandidateControlledBuses(), VoltageControl.Type.SHUNT).stream().filter(bus -> IncrementalShuntVoltageControlOuterLoop.isOutOfDeadband(bus.getShuntVoltageControl().orElseThrow())).toList();
    }

    public static List<LfShunt> getControllerElementsOutOfDeadband(List<LfBus> controlledBusesOutOfDeadband) {
        return controlledBusesOutOfDeadband.stream().flatMap(bus -> bus.getShuntVoltageControl().orElseThrow().getMergedControllerElements().stream()).filter(Predicate.not(LfElement::isDisabled)).toList();
    }

    public static List<LfShunt> getControllerElements(IncrementalContextData contextData) {
        return IncrementalContextData.getControllerElements(contextData.getCandidateControlledBuses(), VoltageControl.Type.SHUNT);
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        IncrementalContextData contextData = new IncrementalContextData(context.getNetwork(), VoltageControl.Type.SHUNT);
        context.setData(contextData);
        for (LfShunt shunt : IncrementalShuntVoltageControlOuterLoop.getControllerElements(contextData)) {
            shunt.getVoltageControl().ifPresent(voltageControl -> shunt.setVoltageControlEnabled(false));
            for (LfShunt.Controller lfShuntController : shunt.getControllers()) {
                contextData.getControllersContexts().put(lfShuntController.getId(), new IncrementalContextData.ControllerContext(3));
            }
        }
    }

    private void adjustB(ShuntVoltageControl voltageControl, List<LfShunt> sortedControllerShunts, LfBus controlledBus, IncrementalContextData contextData, SensitivityContext sensitivityContext, double diffV, MutableObject<Integer> numAdjustedShunts) {
        double remainingDiffV = diffV;
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            for (LfShunt controllerShunt : sortedControllerShunts) {
                List<LfShunt.Controller> controllers = controllerShunt.getControllers();
                if (controllers.isEmpty()) continue;
                double sensitivity = sensitivityContext.calculateSensitivityFromBToV(controllerShunt, controlledBus);
                for (LfShunt.Controller controller : controllers) {
                    IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controller.getId());
                    double halfTargetDeadband = IncrementalShuntVoltageControlOuterLoop.getHalfTargetDeadband(voltageControl);
                    if (Math.abs(remainingDiffV) > halfTargetDeadband) {
                        double previousB = controller.getB();
                        double deltaB = remainingDiffV / sensitivity;
                        Direction direction = controller.updateSectionB(deltaB, 1, controllerContext.getAllowedDirection()).orElse(null);
                        if (direction == null) continue;
                        controllerContext.updateAllowedDirection(direction);
                        remainingDiffV -= (controller.getB() - previousB) * sensitivity;
                        hasChanged = true;
                        numAdjustedShunts.setValue((Object)((Integer)numAdjustedShunts.getValue() + 1));
                        continue;
                    }
                    LOGGER.trace("Controller shunt '{}' is in its deadband: deadband {} vs voltage difference {}", new Object[]{controllerShunt.getId(), halfTargetDeadband * controlledBus.getNominalV(), Math.abs(diffV) * controlledBus.getNominalV()});
                }
            }
        }
    }

    private static double getDiffV(ShuntVoltageControl voltageControl) {
        double targetV = voltageControl.getControlledBus().getHighestPriorityTargetV().orElseThrow();
        double v = voltageControl.getControlledBus().getV();
        return targetV - v;
    }

    private static boolean isOutOfDeadband(ShuntVoltageControl voltageControl) {
        boolean outOfDeadband;
        double diffV = IncrementalShuntVoltageControlOuterLoop.getDiffV(voltageControl);
        double halfTargetDeadband = IncrementalShuntVoltageControlOuterLoop.getHalfTargetDeadband(voltageControl);
        boolean bl = outOfDeadband = Math.abs(diffV) > halfTargetDeadband;
        if (outOfDeadband) {
            List<LfShunt> controllers = voltageControl.getMergedControllerElements().stream().filter(shunt -> !shunt.isDisabled()).toList();
            LOGGER.trace("Controlled bus '{}' ({} controllers) is outside of its deadband (half is {} kV) and could need a voltage adjustment of {} kV", new Object[]{voltageControl.getControlledBus().getId(), controllers.size(), halfTargetDeadband * voltageControl.getControlledBus().getNominalV(), diffV * voltageControl.getControlledBus().getNominalV()});
        }
        return outOfDeadband;
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        MutableObject status = new MutableObject((Object)OuterLoopStatus.STABLE);
        LfNetwork network = context.getNetwork();
        AcLoadFlowContext loadFlowContext = (AcLoadFlowContext)context.getLoadFlowContext();
        IncrementalContextData contextData = (IncrementalContextData)context.getData();
        List<LfBus> controlledBusesOutOfDeadband = IncrementalShuntVoltageControlOuterLoop.getControlledBusesOutOfDeadband(contextData);
        List<LfShunt> controllerShuntsOutOfDeadband = IncrementalShuntVoltageControlOuterLoop.getControllerElementsOutOfDeadband(controlledBusesOutOfDeadband);
        if (controllerShuntsOutOfDeadband.isEmpty()) {
            return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
        }
        MutableObject numAdjustedShunts = new MutableObject((Object)0);
        SensitivityContext sensitivityContext = new SensitivityContext(network, controllerShuntsOutOfDeadband, loadFlowContext.getEquationSystem(), loadFlowContext.getJacobianMatrix());
        controlledBusesOutOfDeadband.forEach(controlledBus -> {
            ShuntVoltageControl voltageControl = controlledBus.getShuntVoltageControl().orElseThrow();
            double diffV = IncrementalShuntVoltageControlOuterLoop.getDiffV(voltageControl);
            List<LfShunt> sortedControllers = voltageControl.getMergedControllerElements().stream().filter(shunt -> !shunt.isDisabled()).sorted(Comparator.comparingDouble(LfShunt::getBMagnitude).reversed()).toList();
            this.adjustB(voltageControl, sortedControllers, (LfBus)controlledBus, contextData, sensitivityContext, diffV, (MutableObject<Integer>)numAdjustedShunts);
        });
        if ((Integer)numAdjustedShunts.getValue() != 0) {
            status.setValue((Object)OuterLoopStatus.UNSTABLE);
            ReportNode iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
            Reports.reportShuntVoltageControlChangedSection(iterationReportNode, (Integer)numAdjustedShunts.getValue());
        }
        return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
    }

    protected static double getHalfTargetDeadband(ShuntVoltageControl voltageControl) {
        return voltageControl.getTargetDeadband().orElse(0.1 / voltageControl.getControlledBus().getNominalV()) / 2.0;
    }

    static class SensitivityContext {
        private final DenseMatrix sensitivities;
        private final int[] controllerShuntIndex;

        public SensitivityContext(LfNetwork network, List<LfShunt> controllerShunts, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            this.controllerShuntIndex = SensitivityContext.createControllerShuntIndex(network, controllerShunts);
            this.sensitivities = SensitivityContext.calculateSensitivityValues(controllerShunts, this.controllerShuntIndex, equationSystem, j);
        }

        private static int[] createControllerShuntIndex(LfNetwork network, List<LfShunt> controllerShunts) {
            int[] controllerShuntIndex = new int[network.getShunts().size()];
            int i = 0;
            while (i < controllerShunts.size()) {
                LfShunt controllerShunt = controllerShunts.get(i);
                controllerShuntIndex[controllerShunt.getNum()] = i++;
            }
            return controllerShuntIndex;
        }

        private static DenseMatrix calculateSensitivityValues(List<LfShunt> controllerShunts, int[] controllerShuntIndex, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            int nRows = equationSystem.getIndex().getSortedEquationsToSolve().size();
            int nColumns = controllerShunts.size();
            DenseMatrix rhs = new DenseMatrix(nRows, nColumns);
            for (LfShunt controllerShunt : controllerShunts) {
                equationSystem.getEquation(controllerShunt.getNum(), AcEquationType.SHUNT_TARGET_B).ifPresent(equation -> rhs.set(equation.getColumn(), controllerShuntIndex[controllerShunt.getNum()], 1.0));
            }
            j.solveTransposed(rhs);
            return rhs;
        }

        private static EquationTerm<AcVariableType, AcEquationType> getCalculatedV(LfBus controlledBus) {
            return (EquationTerm)controlledBus.getCalculatedV();
        }

        double calculateSensitivityFromBToV(LfShunt controllerShunt, LfBus controlledBus) {
            return SensitivityContext.getCalculatedV(controlledBus).calculateSensi(this.sensitivities, this.controllerShuntIndex[controllerShunt.getNum()]);
        }
    }
}

