/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AbstractTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalTransformerVoltageControlOuterLoop
extends AbstractTransformerVoltageControlOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalTransformerVoltageControlOuterLoop.class);
    public static final String NAME = "IncrementalTransformerVoltageControl";
    private static final int MAX_DIRECTION_CHANGE = 3;
    private final int maxTapShift;

    public IncrementalTransformerVoltageControlOuterLoop(int maxTapShift) {
        this.maxTapShift = maxTapShift;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static List<LfBus> getControlledBusesOutOfDeadband(IncrementalContextData contextData) {
        return IncrementalContextData.getControlledBuses(contextData.getCandidateControlledBuses(), VoltageControl.Type.TRANSFORMER).stream().filter(bus -> IncrementalTransformerVoltageControlOuterLoop.isOutOfDeadband(bus.getTransformerVoltageControl().orElseThrow())).toList();
    }

    public static List<LfBranch> getControllerElementsOutOfDeadband(List<LfBus> controlledBusesOutOfDeadband) {
        return controlledBusesOutOfDeadband.stream().flatMap(bus -> bus.getTransformerVoltageControl().orElseThrow().getMergedControllerElements().stream()).filter(Predicate.not(LfElement::isDisabled)).filter(LfBranch::isConnectedAtBothSides).toList();
    }

    public static List<LfBranch> getControllerElements(IncrementalContextData contextData) {
        return IncrementalContextData.getControllerElements(contextData.getCandidateControlledBuses(), VoltageControl.Type.TRANSFORMER);
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        IncrementalContextData contextData = new IncrementalContextData(context.getNetwork(), VoltageControl.Type.TRANSFORMER);
        context.setData(contextData);
        for (LfBranch branch : IncrementalTransformerVoltageControlOuterLoop.getControllerElements(contextData)) {
            branch.getVoltageControl().ifPresent(voltageControl -> branch.setVoltageControlEnabled(false));
            contextData.getControllersContexts().put(branch.getId(), new IncrementalContextData.ControllerContext(3));
        }
    }

    private boolean adjustWithOneController(LfBranch controllerBranch, LfBus controlledBus, IncrementalContextData contextData, SensitivityContext sensitivities, double diffV, List<String> controlledBusesWithAllItsControllersToLimit) {
        IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controllerBranch.getId());
        double sensitivity = sensitivities.calculateSensitivityFromRToV(controllerBranch, controlledBus);
        PiModel piModel = controllerBranch.getPiModel();
        int previousTapPosition = piModel.getTapPosition();
        double deltaR1 = diffV / sensitivity;
        return piModel.updateTapPositionToReachNewR1(deltaR1, this.maxTapShift, controllerContext.getAllowedDirection()).map(direction -> {
            controllerContext.updateAllowedDirection((Direction)((Object)direction));
            Range<Integer> tapPositionRange = piModel.getTapPositionRange();
            LOGGER.debug("Controller branch '{}' change tap from {} to {} (full range: {})", new Object[]{controllerBranch.getId(), previousTapPosition, piModel.getTapPosition(), tapPositionRange});
            if (piModel.getTapPosition() == ((Integer)tapPositionRange.getMinimum()).intValue() || piModel.getTapPosition() == ((Integer)tapPositionRange.getMaximum()).intValue()) {
                controlledBusesWithAllItsControllersToLimit.add(controlledBus.getId());
            }
            return direction;
        }).isPresent();
    }

    private boolean adjustWithSeveralControllers(List<LfBranch> controllerBranches, LfBus controlledBus, IncrementalContextData contextData, SensitivityContext sensitivityContext, double diffV, double halfTargetDeadband, List<String> controlledBusesWithAllItsControllersToLimit) {
        MutableBoolean adjusted = new MutableBoolean(false);
        List<Integer> previousTapPositions = controllerBranches.stream().map(controllerBranch -> controllerBranch.getPiModel().getTapPosition()).toList();
        MutableDouble remainingDiffV = new MutableDouble(diffV);
        MutableBoolean hasChanged = new MutableBoolean(true);
        while (hasChanged.booleanValue()) {
            hasChanged.setValue(false);
            for (LfBranch controllerBranch2 : controllerBranches) {
                if (!(Math.abs(remainingDiffV.getValue()) > halfTargetDeadband)) continue;
                IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controllerBranch2.getId());
                double sensitivity = sensitivityContext.calculateSensitivityFromRToV(controllerBranch2, controlledBus);
                PiModel piModel = controllerBranch2.getPiModel();
                double previousR1 = piModel.getR1();
                double deltaR1 = remainingDiffV.doubleValue() / sensitivity;
                piModel.updateTapPositionToReachNewR1(deltaR1, 1, controllerContext.getAllowedDirection()).ifPresent(direction -> {
                    controllerContext.updateAllowedDirection((Direction)((Object)direction));
                    remainingDiffV.add(-(piModel.getR1() - previousR1) * sensitivity);
                    hasChanged.setValue(true);
                    adjusted.setValue(true);
                });
            }
        }
        boolean allControllersToLimit = true;
        for (int i = 0; i < controllerBranches.size(); ++i) {
            LfBranch controllerBranch3 = controllerBranches.get(i);
            PiModel piModel = controllerBranch3.getPiModel();
            int previousTapPosition = previousTapPositions.get(i);
            Range<Integer> tapPositionRange = piModel.getTapPositionRange();
            if (piModel.getTapPosition() != previousTapPosition) {
                LOGGER.debug("Controller branch '{}' (controlled bus '{}') change tap from {} to {} (full range: {})", new Object[]{controllerBranch3.getId(), controlledBus.getId(), previousTapPosition, piModel.getTapPosition(), tapPositionRange});
            }
            if (piModel.getTapPosition() == ((Integer)tapPositionRange.getMinimum()).intValue() || piModel.getTapPosition() == ((Integer)tapPositionRange.getMaximum()).intValue()) continue;
            allControllersToLimit = false;
        }
        if (allControllersToLimit) {
            controlledBusesWithAllItsControllersToLimit.add(controlledBus.getId());
        }
        return adjusted.booleanValue();
    }

    private static double getDiffV(TransformerVoltageControl voltageControl) {
        double targetV = voltageControl.getControlledBus().getHighestPriorityTargetV().orElseThrow();
        double v = voltageControl.getControlledBus().getV();
        return targetV - v;
    }

    private static boolean isOutOfDeadband(TransformerVoltageControl voltageControl) {
        boolean outOfDeadband;
        double diffV = IncrementalTransformerVoltageControlOuterLoop.getDiffV(voltageControl);
        double halfTargetDeadband = IncrementalTransformerVoltageControlOuterLoop.getHalfTargetDeadband(voltageControl);
        boolean bl = outOfDeadband = Math.abs(diffV) > halfTargetDeadband;
        if (outOfDeadband) {
            List<LfBranch> controllers = voltageControl.getMergedControllerElements().stream().filter(b -> !b.isDisabled()).toList();
            LOGGER.trace("Controlled bus '{}' ({} controllers) is outside of its deadband (half is {} kV) and could need a voltage adjustment of {} kV", new Object[]{voltageControl.getControlledBus().getId(), controllers.size(), halfTargetDeadband * voltageControl.getControlledBus().getNominalV(), diffV * voltageControl.getControlledBus().getNominalV()});
        }
        return outOfDeadband;
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        ReportNode iterationReportNode;
        MutableObject status = new MutableObject((Object)OuterLoopStatus.STABLE);
        LfNetwork network = context.getNetwork();
        AcLoadFlowContext loadFlowContext = (AcLoadFlowContext)context.getLoadFlowContext();
        IncrementalContextData contextData = (IncrementalContextData)context.getData();
        List<LfBus> controlledBusesOutOfDeadband = IncrementalTransformerVoltageControlOuterLoop.getControlledBusesOutOfDeadband(contextData);
        List<LfBranch> controllerBranchesOutOfDeadband = IncrementalTransformerVoltageControlOuterLoop.getControllerElementsOutOfDeadband(controlledBusesOutOfDeadband);
        if (controllerBranchesOutOfDeadband.isEmpty()) {
            return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
        }
        SensitivityContext sensitivityContext = new SensitivityContext(network, controllerBranchesOutOfDeadband, loadFlowContext.getEquationSystem(), loadFlowContext.getJacobianMatrix());
        ArrayList controlledBusesAdjusted = new ArrayList();
        ArrayList controlledBusesWithAllItsControllersToLimit = new ArrayList();
        controlledBusesOutOfDeadband.forEach(controlledBus -> {
            TransformerVoltageControl voltageControl = controlledBus.getTransformerVoltageControl().orElseThrow();
            double diffV = IncrementalTransformerVoltageControlOuterLoop.getDiffV(voltageControl);
            double halfTargetDeadband = IncrementalTransformerVoltageControlOuterLoop.getHalfTargetDeadband(voltageControl);
            List<LfBranch> controllers = voltageControl.getMergedControllerElements().stream().filter(b -> !b.isDisabled()).toList();
            boolean adjusted = controllers.size() == 1 ? this.adjustWithOneController(controllers.get(0), (LfBus)controlledBus, contextData, sensitivityContext, diffV, controlledBusesWithAllItsControllersToLimit) : this.adjustWithSeveralControllers(controllers, (LfBus)controlledBus, contextData, sensitivityContext, diffV, halfTargetDeadband, controlledBusesWithAllItsControllersToLimit);
            if (adjusted) {
                controlledBusesAdjusted.add(controlledBus.getId());
                status.setValue((Object)OuterLoopStatus.UNSTABLE);
            }
        });
        Object object = iterationReportNode = !controlledBusesOutOfDeadband.isEmpty() || !controlledBusesAdjusted.isEmpty() || !controlledBusesWithAllItsControllersToLimit.isEmpty() ? Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1) : null;
        if (!controlledBusesOutOfDeadband.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                Map largestMismatches = controlledBusesOutOfDeadband.stream().map(controlledBus -> Pair.of((Object)controlledBus.getId(), (Object)Math.abs(IncrementalTransformerVoltageControlOuterLoop.getDiffV(controlledBus.getTransformerVoltageControl().orElseThrow()) * controlledBus.getNominalV()))).sorted((p1, p2) -> Double.compare((Double)p2.getRight(), (Double)p1.getRight())).limit(3L).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (key1, key2) -> key1, LinkedHashMap::new));
                LOGGER.info("{} controlled bus voltages are outside of their target deadband, largest ones are: {}", (Object)controlledBusesOutOfDeadband.size(), (Object)largestMismatches);
            }
            Reports.reportTransformerControlBusesOutsideDeadband(Objects.requireNonNull(iterationReportNode), controlledBusesOutOfDeadband.size());
        }
        if (!controlledBusesAdjusted.isEmpty()) {
            LOGGER.info("{} controlled bus voltages have been adjusted by changing at least one tap", (Object)controlledBusesAdjusted.size());
            Reports.reportTransformerControlChangedTaps(Objects.requireNonNull(iterationReportNode), controlledBusesAdjusted.size());
        }
        if (!controlledBusesWithAllItsControllersToLimit.isEmpty()) {
            LOGGER.info("{} controlled buses have all its controllers to a tap limit: {}", (Object)controlledBusesWithAllItsControllersToLimit.size(), controlledBusesWithAllItsControllersToLimit);
            Reports.reportTransformerControlTapLimit(Objects.requireNonNull(iterationReportNode), controlledBusesWithAllItsControllersToLimit.size());
        }
        return new OuterLoopResult(this, (OuterLoopStatus)((Object)status.getValue()));
    }

    static class SensitivityContext {
        private final DenseMatrix sensitivities;
        private final int[] controllerBranchIndex;

        public SensitivityContext(LfNetwork network, List<LfBranch> controllerBranches, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            this.controllerBranchIndex = LfBranch.createIndex(network, controllerBranches);
            this.sensitivities = SensitivityContext.calculateSensitivityValues(controllerBranches, this.controllerBranchIndex, equationSystem, j);
        }

        private static DenseMatrix calculateSensitivityValues(List<LfBranch> controllerBranches, int[] controllerBranchIndex, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j) {
            int nRows = equationSystem.getIndex().getSortedEquationsToSolve().size();
            int nColumns = controllerBranches.size();
            DenseMatrix rhs = new DenseMatrix(nRows, nColumns);
            for (LfBranch controllerBranch : controllerBranches) {
                equationSystem.getEquation(controllerBranch.getNum(), AcEquationType.BRANCH_TARGET_RHO1).ifPresent(equation -> rhs.set(equation.getColumn(), controllerBranchIndex[controllerBranch.getNum()], 1.0));
            }
            j.solveTransposed(rhs);
            return rhs;
        }

        private static EquationTerm<AcVariableType, AcEquationType> getCalculatedV(LfBus controlledBus) {
            return (EquationTerm)controlledBus.getCalculatedV();
        }

        double calculateSensitivityFromRToV(LfBranch controllerBranch, LfBus controlledBus) {
            return SensitivityContext.getCalculatedV(controlledBus).calculateSensi(this.sensitivities, this.controllerBranchIndex[controllerBranch.getNum()]);
        }
    }
}

