/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfStaticVarCompensator;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringVoltageOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringVoltageOuterLoop.class);
    public static final String NAME = "VoltageMonitoring";

    @Override
    public String getName() {
        return NAME;
    }

    private static void switchPqPv(List<PqToPvBus> pqToPvBuses, ReportNode reportNode) {
        for (PqToPvBus pqToPvBus : pqToPvBuses) {
            LfBus controllerBus = pqToPvBus.controllerBus;
            controllerBus.setGeneratorVoltageControlEnabled(true);
            controllerBus.setGenerationTargetQ(0.0);
            if (pqToPvBus.voltageLimitDirection != VoltageLimitDirection.MAX && pqToPvBus.voltageLimitDirection != VoltageLimitDirection.MIN) continue;
            double newTargetV = MonitoringVoltageOuterLoop.getSvcTargetV(controllerBus, pqToPvBus.voltageLimitDirection);
            controllerBus.getGeneratorVoltageControl().ifPresent(vc -> vc.setTargetValue(newTargetV));
            Reports.reportStandByAutomatonActivation(reportNode, controllerBus.getId(), newTargetV);
            if (!LOGGER.isTraceEnabled()) continue;
            if (pqToPvBus.voltageLimitDirection == VoltageLimitDirection.MAX) {
                LOGGER.trace("Switch bus '{}' PQ -> PV with high targetV={}", (Object)controllerBus.getId(), (Object)newTargetV);
                continue;
            }
            LOGGER.trace("Switch bus '{}' PQ -> PV with low targetV={}", (Object)controllerBus.getId(), (Object)newTargetV);
        }
    }

    private static double getBusV(LfBus bus) {
        return bus.getGeneratorVoltageControl().map(vc -> vc.getControlledBus().getV()).orElse(Double.NaN);
    }

    private static void checkPqBusForVoltageLimits(LfBus controllerCapableBus, List<PqToPvBus> pqToPvBuses, Range<Double> voltageLimit) {
        double busV = MonitoringVoltageOuterLoop.getBusV(controllerCapableBus);
        if (busV > (Double)voltageLimit.getMaximum()) {
            pqToPvBuses.add(new PqToPvBus(controllerCapableBus, VoltageLimitDirection.MAX));
        }
        if (busV < (Double)voltageLimit.getMinimum()) {
            pqToPvBuses.add(new PqToPvBus(controllerCapableBus, VoltageLimitDirection.MIN));
        }
    }

    private static Optional<LfStaticVarCompensator> findMonitoringSvc(LfBus bus) {
        return bus.getGenerators().stream().filter(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.MONITORING_VOLTAGE).findFirst().map(LfStaticVarCompensator.class::cast);
    }

    private static Optional<Range<Double>> getControlledBusVoltageLimits(LfBus controllerCapableBus) {
        return MonitoringVoltageOuterLoop.findMonitoringSvc(controllerCapableBus).flatMap(generator -> generator.getStandByAutomaton().map(automaton -> Range.of((Comparable)Double.valueOf(automaton.getLowVoltageThreshold()), (Comparable)Double.valueOf(automaton.getHighVoltageThreshold()))));
    }

    private static double getSvcTargetV(LfBus bus, VoltageLimitDirection direction) {
        return MonitoringVoltageOuterLoop.findMonitoringSvc(bus).flatMap(svc -> svc.getStandByAutomaton().map(automaton -> {
            svc.setGeneratorControlType(LfGenerator.GeneratorControlType.VOLTAGE);
            if (direction == VoltageLimitDirection.MIN) {
                return automaton.getLowTargetV();
            }
            return automaton.getHighTargetV();
        })).orElse(Double.NaN);
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        ArrayList<PqToPvBus> pqToPvBuses = new ArrayList<PqToPvBus>();
        context.getNetwork().getControllerElements(VoltageControl.Type.GENERATOR).stream().filter(bus -> !bus.isGeneratorVoltageControlEnabled()).forEach(bus -> MonitoringVoltageOuterLoop.getControlledBusVoltageLimits(bus).ifPresent(voltageLimits -> MonitoringVoltageOuterLoop.checkPqBusForVoltageLimits(bus, pqToPvBuses, (Range<Double>)voltageLimits)));
        if (!pqToPvBuses.isEmpty()) {
            MonitoringVoltageOuterLoop.switchPqPv(pqToPvBuses, reportNode);
            status = OuterLoopStatus.UNSTABLE;
        }
        return new OuterLoopResult(this, status);
    }

    private static final class PqToPvBus {
        private final LfBus controllerBus;
        private final VoltageLimitDirection voltageLimitDirection;

        private PqToPvBus(LfBus controllerBus, VoltageLimitDirection voltageLimitDirection) {
            this.controllerBus = controllerBus;
            this.voltageLimitDirection = voltageLimitDirection;
        }
    }

    private static enum VoltageLimitDirection {
        MIN,
        MAX;

    }
}

