/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.AbstractPhaseControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseControlOuterLoop
extends AbstractPhaseControlOuterLoop<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowContext, AcOuterLoopContext>
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhaseControlOuterLoop.class);
    public static final String NAME = "PhaseControl";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        List<LfBranch> controllerBranches = PhaseControlOuterLoop.getControllerBranches(context.getNetwork());
        for (LfBranch controllerBranch2 : controllerBranches.stream().filter(controllerBranch -> controllerBranch.getPhaseControl().orElseThrow().getMode() == TransformerPhaseControl.Mode.CONTROLLER).collect(Collectors.toList())) {
            controllerBranch2.setPhaseControlEnabled(true);
        }
        PhaseControlOuterLoop.fixPhaseShifterNecessaryForConnectivity(context.getNetwork(), controllerBranches);
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        if (context.getIteration() == 0) {
            return new OuterLoopResult(this, this.firstIteration(context));
        }
        if (context.getIteration() > 0) {
            return new OuterLoopResult(this, this.nextIteration(context));
        }
        return new OuterLoopResult(this, OuterLoopStatus.STABLE);
    }

    private OuterLoopStatus firstIteration(AcOuterLoopContext context) {
        List<LfBranch> controllerBranches = PhaseControlOuterLoop.getControllerBranches(context.getNetwork());
        controllerBranches.stream().flatMap(controllerBranch -> controllerBranch.getPhaseControl().stream()).filter(phaseControl -> phaseControl.getMode() == TransformerPhaseControl.Mode.CONTROLLER).forEach(this::switchOffPhaseControl);
        return controllerBranches.isEmpty() ? OuterLoopStatus.STABLE : OuterLoopStatus.UNSTABLE;
    }

    private OuterLoopStatus nextIteration(AcOuterLoopContext context) {
        List unstablePhaseControls = PhaseControlOuterLoop.getControllerBranches(context.getNetwork()).stream().flatMap(branch -> branch.getPhaseControl().stream()).filter(phaseControl -> phaseControl.getMode() == TransformerPhaseControl.Mode.LIMITER).filter(this::changeTapPositions).collect(Collectors.toList());
        return unstablePhaseControls.isEmpty() ? OuterLoopStatus.STABLE : OuterLoopStatus.UNSTABLE;
    }

    private void switchOffPhaseControl(TransformerPhaseControl phaseControl) {
        LfBranch controllerBranch = phaseControl.getControllerBranch();
        controllerBranch.setPhaseControlEnabled(false);
        PiModel piModel = controllerBranch.getPiModel();
        double a1Value = piModel.getA1();
        piModel.roundA1ToClosestTap();
        double roundedA1Value = piModel.getA1();
        LOGGER.info("Round phase shift of '{}': {} -> {}", new Object[]{controllerBranch.getId(), a1Value, roundedA1Value});
    }

    private boolean changeTapPositions(TransformerPhaseControl phaseControl) {
        double currentLimit = phaseControl.getTargetValue();
        LfBranch controllerBranch = phaseControl.getControllerBranch();
        PiModel piModel = controllerBranch.getPiModel();
        if (phaseControl.getControlledSide() == TwoSides.ONE && currentLimit < controllerBranch.getI1().eval()) {
            boolean isSensibilityPositive = this.isSensitivityCurrentPerA1Positive(controllerBranch, TwoSides.ONE);
            return isSensibilityPositive ? piModel.shiftOneTapPositionToChangeA1(Direction.DECREASE) : piModel.shiftOneTapPositionToChangeA1(Direction.INCREASE);
        }
        if (phaseControl.getControlledSide() == TwoSides.TWO && currentLimit < controllerBranch.getI2().eval()) {
            boolean isSensibilityPositive = this.isSensitivityCurrentPerA1Positive(controllerBranch, TwoSides.TWO);
            return isSensibilityPositive ? piModel.shiftOneTapPositionToChangeA1(Direction.DECREASE) : piModel.shiftOneTapPositionToChangeA1(Direction.INCREASE);
        }
        return false;
    }

    private boolean isSensitivityCurrentPerA1Positive(LfBranch controllerBranch, TwoSides controlledSide) {
        if (controlledSide == TwoSides.ONE) {
            ClosedBranchSide1CurrentMagnitudeEquationTerm i1 = (ClosedBranchSide1CurrentMagnitudeEquationTerm)controllerBranch.getI1();
            return i1.der(i1.getA1Var()) > 0.0;
        }
        ClosedBranchSide2CurrentMagnitudeEquationTerm i2 = (ClosedBranchSide2CurrentMagnitudeEquationTerm)controllerBranch.getI2();
        return i2.der(i2.getA1Var()) > 0.0;
    }
}

