/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Reports;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveLimitsOuterLoop
implements AcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveLimitsOuterLoop.class);
    public static final String NAME = "ReactiveLimits";
    private static final double REALISTIC_VOLTAGE_MARGIN = 1.02;
    private static final Comparator<ControllerBusToPqBus> BY_NOMINAL_V_COMPARATOR = Comparator.comparingDouble(controllerBusToPqBus -> controllerBusToPqBus.controllerBus.getGeneratorVoltageControl().map(vc -> -vc.getControlledBus().getNominalV()).orElse(-controllerBusToPqBus.controllerBus.getNominalV()));
    private static final Comparator<ControllerBusToPqBus> BY_TARGET_P_COMPARATOR = Comparator.comparingDouble(controllerBusToPqBus -> -controllerBusToPqBus.controllerBus.getTargetP());
    private static final Comparator<ControllerBusToPqBus> BY_ID_COMPARATOR = Comparator.comparing(controllerBusToPqBus -> controllerBusToPqBus.controllerBus.getId());
    public static final int MAX_SWITCH_PQ_PV_DEFAULT_VALUE = 3;
    private final int maxPqPvSwitch;
    private final double maxReactivePowerMismatch;
    private final double minRealisticVoltage;
    private final double maxRealisticVoltage;
    private final boolean robustMode;

    public ReactiveLimitsOuterLoop(int maxPqPvSwitch, double maxReactivePowerMismatch, boolean robustMode, double minRealisticVoltage, double maxRealisticVoltage) {
        this.maxPqPvSwitch = maxPqPvSwitch;
        this.maxReactivePowerMismatch = maxReactivePowerMismatch;
        this.minRealisticVoltage = minRealisticVoltage;
        this.maxRealisticVoltage = maxRealisticVoltage;
        this.robustMode = robustMode;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private boolean switchPvPq(List<ControllerBusToPqBus> pvToPqBuses, int remainingPvBusCount, ContextData contextData, ReportNode reportNode) {
        boolean done = false;
        int modifiedRemainingPvBusCount = remainingPvBusCount;
        if (modifiedRemainingPvBusCount == 0) {
            ControllerBusToPqBus strongestPvToPqBus = pvToPqBuses.stream().min(BY_NOMINAL_V_COMPARATOR.thenComparing(BY_TARGET_P_COMPARATOR).thenComparing(BY_ID_COMPARATOR)).orElseThrow(IllegalStateException::new);
            pvToPqBuses.remove(strongestPvToPqBus);
            ++modifiedRemainingPvBusCount;
            LOGGER.warn("All PV buses should switch PQ, strongest one '{}' will stay PV", (Object)strongestPvToPqBus.controllerBus.getId());
            Reports.reportBusForcedToBePv(reportNode, strongestPvToPqBus.controllerBus.getId());
        }
        if (!pvToPqBuses.isEmpty()) {
            done = true;
            ReportNode summary = Reports.reportPvToPqBuses(reportNode, pvToPqBuses.size(), modifiedRemainingPvBusCount);
            boolean log = LOGGER.isTraceEnabled();
            for (ControllerBusToPqBus pvToPqBus : pvToPqBuses) {
                LfBus controllerBus = pvToPqBus.controllerBus;
                controllerBus.setGenerationTargetQ(pvToPqBus.qLimit);
                controllerBus.setQLimitType(pvToPqBus.limitType);
                controllerBus.setGeneratorVoltageControlEnabled(false);
                contextData.incrementPvPqSwitchCount(controllerBus.getId());
                switch (pvToPqBus.limitType) {
                    case MAX_Q: {
                        Reports.reportPvToPqMaxQ(summary, controllerBus, pvToPqBus.q, pvToPqBus.qLimit, log, LOGGER);
                        break;
                    }
                    case MIN_Q: {
                        Reports.reportPvToPqMinQ(summary, controllerBus, pvToPqBus.q, pvToPqBus.qLimit, log, LOGGER);
                        break;
                    }
                    case MIN_REALISTIC_V: {
                        Reports.reportPvToPqMinRealisticV(summary, controllerBus, pvToPqBus.qLimit, this.minRealisticVoltage, log, LOGGER);
                        break;
                    }
                    case MAX_REALISTIC_V: {
                        Reports.reportPvToPqMaxRealisticV(summary, controllerBus, pvToPqBus.qLimit, this.maxRealisticVoltage, log, LOGGER);
                    }
                }
            }
        }
        LOGGER.info("{} buses switched PV -> PQ ({} bus remains PV)", (Object)pvToPqBuses.size(), (Object)modifiedRemainingPvBusCount);
        return done;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        context.setData(new ContextData());
    }

    private static boolean switchPqPv(List<PqToPvBus> pqToPvBuses, ContextData contextData, ReportNode reportNode, int maxPqPvSwitch) {
        int pqPvSwitchCount = 0;
        boolean log = LOGGER.isTraceEnabled();
        ArrayList<ReportNode> pqPvNodes = new ArrayList<ReportNode>();
        for (PqToPvBus pqToPvBus : pqToPvBuses) {
            LfBus controllerBus = pqToPvBus.controllerBus;
            int pvPqSwitchCount = contextData.getPvPqSwitchCount(controllerBus.getId());
            if (pvPqSwitchCount >= maxPqPvSwitch) {
                pqPvNodes.add(Reports.createRootReportPvPqSwitchLimit(reportNode, controllerBus, pvPqSwitchCount, log, LOGGER));
                continue;
            }
            controllerBus.setGeneratorVoltageControlEnabled(true);
            controllerBus.setGenerationTargetQ(0.0);
            controllerBus.setQLimitType(null);
            ++pqPvSwitchCount;
            if (pqToPvBus.limitType.isMaxLimit()) {
                pqPvNodes.add(Reports.createRootReportPqToPvBusMaxLimit(reportNode, controllerBus, controllerBus.getGeneratorVoltageControl().map(VoltageControl::getControlledBus).orElseThrow(), ReactiveLimitsOuterLoop.getBusTargetV(controllerBus), log, LOGGER));
                continue;
            }
            pqPvNodes.add(Reports.createRootReportPqToPvBusMinLimit(reportNode, controllerBus, controllerBus.getGeneratorVoltageControl().map(VoltageControl::getControlledBus).orElseThrow(), ReactiveLimitsOuterLoop.getBusTargetV(controllerBus), log, LOGGER));
        }
        if (!pqPvNodes.isEmpty()) {
            ReportNode summary = Reports.reportPqToPvBuses(reportNode, pqPvSwitchCount, pqToPvBuses.size() - pqPvSwitchCount);
            pqPvNodes.forEach(arg_0 -> ((ReportNode)summary).include(arg_0));
        }
        LOGGER.info("{} buses switched PQ -> PV ({} buses blocked PQ because have reach max number of switch)", (Object)pqPvSwitchCount, (Object)(pqToPvBuses.size() - pqPvSwitchCount));
        return pqPvSwitchCount > 0;
    }

    private void checkControllerBus(LfBus controllerBus, List<ControllerBusToPqBus> buses, MutableInt remainingUnchangedBusCount) {
        double minQ = controllerBus.getMinQ();
        double maxQ = controllerBus.getMaxQ();
        double q = controllerBus.getQ().eval() + controllerBus.getLoadTargetQ();
        boolean remainsPV = true;
        boolean generatorRemoteController = this.isGeneratorRemoteController(controllerBus);
        if (q < minQ) {
            buses.add(new ControllerBusToPqBus(controllerBus, q, minQ, LfBus.QLimitType.MIN_Q));
            remainsPV = false;
        } else if (q > maxQ) {
            buses.add(new ControllerBusToPqBus(controllerBus, q, maxQ, LfBus.QLimitType.MAX_Q));
            remainsPV = false;
        }
        if (this.robustMode && generatorRemoteController && !remainsPV && (this.isUnrealisticLowVoltage(controllerBus) || this.isUnrealisticHighVoltage(controllerBus))) {
            controllerBus.setV(1.0);
        }
        if (this.robustMode && remainsPV && generatorRemoteController) {
            if (this.isUnrealisticLowVoltage(controllerBus)) {
                controllerBus.setV(1.0);
                buses.add(new ControllerBusToPqBus(controllerBus, q, this.getInitialGenerationTargetQ(controllerBus), LfBus.QLimitType.MIN_REALISTIC_V));
                remainsPV = false;
            } else if (this.isUnrealisticHighVoltage(controllerBus)) {
                controllerBus.setV(1.0);
                buses.add(new ControllerBusToPqBus(controllerBus, q, this.getInitialGenerationTargetQ(controllerBus), LfBus.QLimitType.MAX_REALISTIC_V));
                remainsPV = false;
            }
        }
        if (remainsPV) {
            remainingUnchangedBusCount.increment();
        }
    }

    private double getInitialGenerationTargetQ(LfBus controllerBus) {
        return controllerBus.getGenerators().stream().mapToDouble(LfGenerator::getTargetQ).sum();
    }

    private boolean isGeneratorRemoteController(LfBus controllerBus) {
        return controllerBus.getGeneratorVoltageControl().map(c -> c.getControlledBus() != controllerBus).orElse(false);
    }

    private boolean isUnrealisticLowVoltage(LfBus controllerBus) {
        return controllerBus.getV() < this.minRealisticVoltage * 1.02;
    }

    private boolean isUnrealisticHighVoltage(LfBus controllerBus) {
        return controllerBus.getV() > this.maxRealisticVoltage / 1.02;
    }

    private void checkPqBus(LfBus controllerCapableBus, List<PqToPvBus> pqToPvBuses, List<LfBus> busesWithUpdatedQLimits, double maxReactivePowerMismatch, boolean canSwitchPqToPv) {
        double minQ = controllerCapableBus.getMinQ();
        double maxQ = controllerCapableBus.getMaxQ();
        double q = controllerCapableBus.getGenerationTargetQ();
        controllerCapableBus.getQLimitType().ifPresent(qLimitType -> {
            if (qLimitType.isMinLimit()) {
                if (ReactiveLimitsOuterLoop.getBusV(controllerCapableBus) < ReactiveLimitsOuterLoop.getBusTargetV(controllerCapableBus) && canSwitchPqToPv) {
                    pqToPvBuses.add(new PqToPvBus(controllerCapableBus, LfBus.QLimitType.MIN_Q));
                } else if (qLimitType == LfBus.QLimitType.MIN_Q && Math.abs(minQ - q) > maxReactivePowerMismatch) {
                    LOGGER.trace("PQ bus {} with updated Q limits, previous minQ {} new minQ {}", new Object[]{controllerCapableBus.getId(), q, minQ});
                    controllerCapableBus.setGenerationTargetQ(minQ);
                    busesWithUpdatedQLimits.add(controllerCapableBus);
                }
            } else if (qLimitType.isMaxLimit()) {
                if (ReactiveLimitsOuterLoop.getBusV(controllerCapableBus) > ReactiveLimitsOuterLoop.getBusTargetV(controllerCapableBus) && canSwitchPqToPv) {
                    pqToPvBuses.add(new PqToPvBus(controllerCapableBus, LfBus.QLimitType.MAX_Q));
                } else if (qLimitType == LfBus.QLimitType.MAX_Q && Math.abs(maxQ - q) > maxReactivePowerMismatch) {
                    LOGGER.trace("PQ bus {} with updated Q limits, previous maxQ {} new maxQ {}", new Object[]{controllerCapableBus.getId(), q, maxQ});
                    controllerCapableBus.setGenerationTargetQ(maxQ);
                    busesWithUpdatedQLimits.add(controllerCapableBus);
                }
            }
        });
    }

    private boolean switchReactiveControllerBusPq(List<ControllerBusToPqBus> reactiveControllerBusesToPqBuses, ReportNode reportNode) {
        int switchCount = 0;
        ArrayList<ReportNode> switchedNodes = new ArrayList<ReportNode>();
        boolean log = LOGGER.isTraceEnabled();
        for (ControllerBusToPqBus bus : reactiveControllerBusesToPqBuses) {
            LfBus controllerBus = bus.controllerBus;
            controllerBus.setGeneratorReactivePowerControlEnabled(false);
            controllerBus.setGenerationTargetQ(bus.qLimit);
            ++switchCount;
            switch (bus.limitType) {
                case MAX_Q: {
                    switchedNodes.add(Reports.createRootReportReactiveControllerBusesToPqMaxQ(reportNode, controllerBus, bus.q, bus.qLimit, log, LOGGER));
                    break;
                }
                case MIN_Q: {
                    switchedNodes.add(Reports.createRootReportReactiveControllerBusesToPqMinQ(reportNode, controllerBus, bus.q, bus.qLimit, log, LOGGER));
                    break;
                }
                case MIN_REALISTIC_V: 
                case MAX_REALISTIC_V: {
                    LOGGER.trace("Switch bus '{}' PV -> PQ, q set to {} = targetQ - v is outside realistic voltage limits [{}pu,{}pu] when remote voltage is maintained", new Object[]{controllerBus.getId(), bus.qLimit * 100.0, this.minRealisticVoltage, this.maxRealisticVoltage});
                }
            }
        }
        if (!switchedNodes.isEmpty()) {
            ReportNode node = Reports.reportReactiveControllerBusesToPqBuses(reportNode, switchCount);
            switchedNodes.forEach(arg_0 -> ((ReportNode)node).include(arg_0));
        }
        LOGGER.info("{} remote reactive power controller buses switched PQ", (Object)switchCount);
        return switchCount > 0;
    }

    private static double getBusTargetV(LfBus bus) {
        return bus.getGeneratorVoltageControl().map(Control::getTargetValue).orElse(Double.NaN);
    }

    private static double getBusV(LfBus bus) {
        return bus.getGeneratorVoltageControl().map(vc -> vc.getControlledBus().getV()).orElse(Double.NaN);
    }

    public static List<LfBus> getReactivePowerControllerElements(LfNetwork network) {
        return network.getBuses().stream().filter(LfBus::hasGeneratorReactivePowerControl).flatMap(bus -> bus.getGeneratorReactivePowerControl().orElseThrow().getControllerBuses().stream()).filter(Predicate.not(LfElement::isDisabled)).toList();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        ArrayList<ControllerBusToPqBus> pvToPqBuses = new ArrayList<ControllerBusToPqBus>();
        ArrayList<PqToPvBus> pqToPvBuses = new ArrayList<PqToPvBus>();
        ArrayList busesWithUpdatedQLimits = new ArrayList();
        MutableInt remainingPvBusCount = new MutableInt();
        ArrayList<ControllerBusToPqBus> reactiveControllerBusesToPqBuses = new ArrayList<ControllerBusToPqBus>();
        MutableInt remainingBusWithReactivePowerControlCount = new MutableInt();
        context.getNetwork().getControllerElements(VoltageControl.Type.GENERATOR).forEach(bus -> {
            if (bus.isGeneratorVoltageControlEnabled()) {
                this.checkControllerBus((LfBus)bus, (List<ControllerBusToPqBus>)pvToPqBuses, remainingPvBusCount);
            } else {
                this.checkPqBus((LfBus)bus, (List<PqToPvBus>)pqToPvBuses, busesWithUpdatedQLimits, this.maxReactivePowerMismatch, !bus.hasGeneratorsWithSlope());
            }
        });
        ReactiveLimitsOuterLoop.getReactivePowerControllerElements(context.getNetwork()).forEach(bus -> {
            if (bus.isGeneratorReactivePowerControlEnabled()) {
                this.checkControllerBus((LfBus)bus, (List<ControllerBusToPqBus>)reactiveControllerBusesToPqBuses, remainingBusWithReactivePowerControlCount);
            }
        });
        ContextData contextData = (ContextData)context.getData();
        ReportNode iterationReportNode = reportNode;
        if (!(pvToPqBuses.isEmpty() && pqToPvBuses.isEmpty() && busesWithUpdatedQLimits.isEmpty() && reactiveControllerBusesToPqBuses.isEmpty())) {
            iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, context.getOuterLoopTotalIterations() + 1);
        }
        if (!pvToPqBuses.isEmpty() && this.switchPvPq(pvToPqBuses, remainingPvBusCount.intValue(), contextData, iterationReportNode)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!pqToPvBuses.isEmpty() && ReactiveLimitsOuterLoop.switchPqPv(pqToPvBuses, contextData, iterationReportNode, this.maxPqPvSwitch)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!busesWithUpdatedQLimits.isEmpty()) {
            LOGGER.info("{} buses blocked at a reactive limit have been adjusted because the reactive limit changed", (Object)busesWithUpdatedQLimits.size());
            Reports.reportBusesWithUpdatedQLimits(iterationReportNode, busesWithUpdatedQLimits.size());
            status = OuterLoopStatus.UNSTABLE;
        }
        if (!reactiveControllerBusesToPqBuses.isEmpty() && this.switchReactiveControllerBusPq(reactiveControllerBusesToPqBuses, iterationReportNode)) {
            status = OuterLoopStatus.UNSTABLE;
        }
        return new OuterLoopResult(this, status);
    }

    @Override
    public boolean canFixUnrealisticState() {
        return true;
    }

    private static final class ControllerBusToPqBus {
        private final LfBus controllerBus;
        private final double q;
        private final double qLimit;
        private final LfBus.QLimitType limitType;

        private ControllerBusToPqBus(LfBus controllerBus, double q, double qLimit, LfBus.QLimitType limitType) {
            this.controllerBus = controllerBus;
            this.q = q;
            this.qLimit = qLimit;
            this.limitType = limitType;
        }
    }

    private static final class ContextData {
        private final Map<String, MutableInt> pvPqSwitchCount = new HashMap<String, MutableInt>();

        private ContextData() {
        }

        void incrementPvPqSwitchCount(String busId) {
            this.pvPqSwitchCount.computeIfAbsent(busId, k -> new MutableInt(0)).increment();
        }

        int getPvPqSwitchCount(String busId) {
            MutableInt counter = this.pvPqSwitchCount.get(busId);
            if (counter == null) {
                return 0;
            }
            return counter.getValue();
        }
    }

    private static final class PqToPvBus {
        private final LfBus controllerBus;
        private final LfBus.QLimitType limitType;

        private PqToPvBus(LfBus controllerBus, LfBus.QLimitType limitType) {
            this.controllerBus = controllerBus;
            this.limitType = limitType;
        }
    }
}

