/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.outerloop.AbstractTransformerVoltageControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.VoltageControl;

public class SimpleTransformerVoltageControlOuterLoop
extends AbstractTransformerVoltageControlOuterLoop {
    public static final String NAME = "SimpleTransformerVoltageControl";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void initialize(AcOuterLoopContext context) {
        for (LfBranch controllerBranch : context.getNetwork().getControllerElements(VoltageControl.Type.TRANSFORMER)) {
            if (!controllerBranch.isConnectedAtBothSides()) continue;
            controllerBranch.setVoltageControlEnabled(true);
        }
        context.getNetwork().fixTransformerVoltageControls();
    }

    @Override
    public OuterLoopResult check(AcOuterLoopContext context, ReportNode reportNode) {
        OuterLoopStatus status = OuterLoopStatus.STABLE;
        if (context.getIteration() == 0) {
            status = this.roundVoltageRatios(context.getNetwork());
        }
        return new OuterLoopResult(this, status);
    }
}

