/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.outerloop.tap;

import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfVscConverterStation;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.ArrayList;
import java.util.List;

public class GeneratorVoltageControlManager {
    private final double minNominalVoltageLimit;
    private final List<LfBus> disabledControllerBuses = new ArrayList<LfBus>();

    public GeneratorVoltageControlManager(LfNetwork network, double limitOverride) {
        this.minNominalVoltageLimit = limitOverride < 0.0 ? GeneratorVoltageControlManager.computeDefaultMinNominalVoltageLimit(network) : limitOverride;
    }

    private static double computeDefaultMinNominalVoltageLimit(LfNetwork network) {
        double defaultMinNominalVoltage = Double.MIN_VALUE;
        for (LfBus bus : network.getBuses()) {
            if (bus.isDisabled() || !bus.isTransformerVoltageControlled() || !GeneratorVoltageControlManager.isTransformerVoltageControlsValidForMaxControlledNominalVoltageCalculation(bus.getTransformerVoltageControl().orElse(null))) continue;
            defaultMinNominalVoltage = Math.max(defaultMinNominalVoltage, bus.getNominalV());
        }
        return defaultMinNominalVoltage;
    }

    private static boolean isTransformerVoltageControlsValidForMaxControlledNominalVoltageCalculation(TransformerVoltageControl transformerVoltageControl) {
        if (transformerVoltageControl != null) {
            for (LfBranch branch : transformerVoltageControl.getControllerElements()) {
                if (branch.isConnectedAtBothSides() && branch.getBus1().getNominalV() != branch.getBus2().getNominalV()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void disableGeneratorVoltageControlsUnderMaxControlledNominalVoltage(LfNetwork network) {
        this.disabledControllerBuses.clear();
        for (LfBus bus : network.getControlledBuses(VoltageControl.Type.GENERATOR)) {
            if (!(bus.getNominalV() <= this.minNominalVoltageLimit)) continue;
            GeneratorVoltageControl voltageControl = bus.getGeneratorVoltageControl().orElseThrow();
            for (LfBus controllerBus : voltageControl.getMergedControllerElements()) {
                if (!controllerBus.isGeneratorVoltageControlEnabled() || this.hasStepUpTransformers(controllerBus, this.minNominalVoltageLimit)) continue;
                controllerBus.setGenerationTargetQ(controllerBus.getQ().eval());
                controllerBus.setGeneratorVoltageControlEnabled(false);
                this.disabledControllerBuses.add(controllerBus);
            }
        }
    }

    public void enableGeneratorVoltageControlsUnderMaxControlledNominalVoltage() {
        for (LfBus controllerBus : this.disabledControllerBuses) {
            controllerBus.setGenerationTargetQ(0.0);
            controllerBus.setGeneratorVoltageControlEnabled(true);
        }
    }

    private boolean hasStepUpTransformers(LfBus bus, double limit) {
        if (bus.getGenerators().stream().anyMatch(LfVscConverterStation.class::isInstance)) {
            return true;
        }
        if (bus.getBranches().stream().anyMatch(b -> b.getVoltageControl().isPresent())) {
            return false;
        }
        double startingNominalVoltage = bus.getNominalV();
        double minConnectedVoltageLevel = bus.getBranches().stream().filter(b -> b.isConnectedAtBothSides()).mapToDouble(b -> Math.max(b.getBus1().getNominalV(), b.getBus2().getNominalV())).min().orElse(-1.0);
        return minConnectedVoltageLevel > startingNominalVoltage && minConnectedVoltageLevel > limit;
    }
}

