/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.PowsyblException;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverParameters;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.apache.commons.compress.utils.Lists;

public interface AcSolverFactory {
    public static List<AcSolverFactory> findAll() {
        return Lists.newArrayList(ServiceLoader.load(AcSolverFactory.class, AcSolverFactory.class.getClassLoader()).iterator());
    }

    public static AcSolverFactory find(String name) {
        Objects.requireNonNull(name);
        return AcSolverFactory.findAll().stream().filter(asf -> name.equals(asf.getName())).findFirst().orElseThrow(() -> new PowsyblException("AC Solver '" + name + "' not found"));
    }

    public String getName();

    public AcSolverParameters createParameters(LoadFlowParameters var1);

    public AcSolver create(LfNetwork var1, AcLoadFlowParameters var2, EquationSystem<AcVariableType, AcEquationType> var3, JacobianMatrix<AcVariableType, AcEquationType> var4, TargetVector<AcVariableType, AcEquationType> var5, EquationVector<AcVariableType, AcEquationType> var6);
}

