/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.Vectors;
import net.jafama.FastMath;

public class DefaultNewtonRaphsonStoppingCriteria
implements NewtonRaphsonStoppingCriteria {
    private final double convEpsPerEq;

    public DefaultNewtonRaphsonStoppingCriteria() {
        this(NewtonRaphsonStoppingCriteria.DEFAULT_CONV_EPS_PER_EQ);
    }

    public DefaultNewtonRaphsonStoppingCriteria(double convEpsPerEq) {
        this.convEpsPerEq = convEpsPerEq;
    }

    @Override
    public NewtonRaphsonStoppingCriteria.TestResult test(double[] fx, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        double norm = Vectors.norm2(fx);
        boolean stop = norm < FastMath.sqrt((double)(this.convEpsPerEq * this.convEpsPerEq * (double)fx.length));
        return new NewtonRaphsonStoppingCriteria.TestResult(stop, norm);
    }
}

