/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.SparseMatrix;
import com.powsybl.math.solver.Kinsol;
import com.powsybl.math.solver.KinsolParameters;
import com.powsybl.math.solver.KinsolResult;
import com.powsybl.math.solver.KinsolStatus;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AbstractAcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.ac.solver.AcSolverUtil;
import com.powsybl.openloadflow.ac.solver.NewtonKrylovParameters;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import java.util.Objects;

public class NewtonKrylov
extends AbstractAcSolver {
    private final NewtonKrylovParameters parameters;

    public NewtonKrylov(LfNetwork network, NewtonKrylovParameters parameters, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j, TargetVector<AcVariableType, AcEquationType> targetVector, EquationVector<AcVariableType, AcEquationType> equationVector) {
        super(network, equationSystem, j, targetVector, equationVector, false);
        this.parameters = Objects.requireNonNull(parameters);
    }

    @Override
    public String getName() {
        return "Newton Krylov";
    }

    private AcSolverStatus getStatus(KinsolStatus status) {
        return switch (status) {
            case KinsolStatus.KIN_SUCCESS, KinsolStatus.KIN_INITIAL_GUESS_OK -> AcSolverStatus.CONVERGED;
            case KinsolStatus.KIN_MAXITER_REACHED -> AcSolverStatus.MAX_ITERATION_REACHED;
            default -> AcSolverStatus.SOLVER_FAILED;
        };
    }

    @Override
    public AcSolverResult run(VoltageInitializer voltageInitializer, ReportNode reportNode) {
        AcSolverUtil.initStateVector(this.network, this.equationSystem, voltageInitializer);
        KinsolParameters kinsolParameters = new KinsolParameters().setMaxIters(this.parameters.getMaxIterations()).setLineSearch(this.parameters.isLineSearch());
        Kinsol kinsol = new Kinsol((SparseMatrix)this.j.getMatrix(), (x, f) -> {
            this.equationSystem.getStateVector().set(x);
            this.equationVector.minus(this.targetVector);
            System.arraycopy(this.equationVector.getArray(), 0, f, 0, this.equationVector.getArray().length);
        }, (x, j) -> this.j.forceUpdate());
        KinsolResult result = kinsol.solveTransposed(this.equationSystem.getStateVector().get(), kinsolParameters);
        if (result.getStatus() == KinsolStatus.KIN_SUCCESS) {
            AcSolverUtil.updateNetwork(this.network, this.equationSystem);
        }
        return new AcSolverResult(this.getStatus(result.getStatus()), (int)result.getIterations(), 0.0);
    }
}

