/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.google.auto.service.AutoService;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.AcSolverParameters;
import com.powsybl.openloadflow.ac.solver.DefaultNewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.NewtonRaphson;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteriaType;
import com.powsybl.openloadflow.ac.solver.PerEquationTypeStoppingCriteria;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.network.LfNetwork;

@AutoService(value={AcSolverFactory.class})
public class NewtonRaphsonFactory
implements AcSolverFactory {
    public static final String NAME = "NEWTON_RAPHSON";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AcSolverParameters createParameters(LoadFlowParameters parameters) {
        OpenLoadFlowParameters parametersExt = OpenLoadFlowParameters.get(parameters);
        return ((NewtonRaphsonParameters)new NewtonRaphsonParameters().setStoppingCriteria(NewtonRaphsonFactory.createNewtonRaphsonStoppingCriteria(parametersExt)).setMaxIterations(parametersExt.getMaxNewtonRaphsonIterations())).setStateVectorScalingMode(parametersExt.getStateVectorScalingMode()).setLineSearchStateVectorScalingMaxIteration(parametersExt.getLineSearchStateVectorScalingMaxIteration()).setLineSearchStateVectorScalingStepFold(parametersExt.getLineSearchStateVectorScalingStepFold()).setMaxVoltageChangeStateVectorScalingMaxDv(parametersExt.getMaxVoltageChangeStateVectorScalingMaxDv()).setMaxVoltageChangeStateVectorScalingMaxDphi(parametersExt.getMaxVoltageChangeStateVectorScalingMaxDphi()).setAlwaysUpdateNetwork(parametersExt.isAlwaysUpdateNetwork());
    }

    @Override
    public AcSolver create(LfNetwork network, AcLoadFlowParameters parameters, EquationSystem<AcVariableType, AcEquationType> equationSystem, JacobianMatrix<AcVariableType, AcEquationType> j, TargetVector<AcVariableType, AcEquationType> targetVector, EquationVector<AcVariableType, AcEquationType> equationVector) {
        return new NewtonRaphson(network, (NewtonRaphsonParameters)parameters.getAcSolverParameters(), equationSystem, j, targetVector, equationVector, parameters.isDetailedReport());
    }

    private static NewtonRaphsonStoppingCriteria createNewtonRaphsonStoppingCriteria(OpenLoadFlowParameters parametersExt) {
        return switch (parametersExt.getNewtonRaphsonStoppingCriteriaType()) {
            default -> throw new IncompatibleClassChangeError();
            case NewtonRaphsonStoppingCriteriaType.UNIFORM_CRITERIA -> new DefaultNewtonRaphsonStoppingCriteria(parametersExt.getNewtonRaphsonConvEpsPerEq());
            case NewtonRaphsonStoppingCriteriaType.PER_EQUATION_TYPE_CRITERIA -> new PerEquationTypeStoppingCriteria(parametersExt.getNewtonRaphsonConvEpsPerEq(), parametersExt.getMaxActivePowerMismatch(), parametersExt.getMaxReactivePowerMismatch(), parametersExt.getMaxVoltageMismatch(), parametersExt.getMaxAngleMismatch(), parametersExt.getMaxRatioMismatch(), parametersExt.getMaxSusceptanceMismatch());
        };
    }
}

