/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.solver;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.LineSearchStateVectorScaling;
import com.powsybl.openloadflow.ac.solver.MaxVoltageChangeStateVectorScaling;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonStoppingCriteria;
import com.powsybl.openloadflow.ac.solver.NoneStateVectorScaling;
import com.powsybl.openloadflow.ac.solver.StateVectorScalingMode;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.TargetVector;
import java.util.Objects;

public interface StateVectorScaling {
    public static StateVectorScaling fromMode(NewtonRaphsonParameters parameters, NewtonRaphsonStoppingCriteria.TestResult initialTestResult) {
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(initialTestResult);
        return switch (parameters.getStateVectorScalingMode()) {
            default -> throw new IncompatibleClassChangeError();
            case StateVectorScalingMode.NONE -> new NoneStateVectorScaling();
            case StateVectorScalingMode.LINE_SEARCH -> new LineSearchStateVectorScaling(initialTestResult, parameters.getLineSearchStateVectorScalingMaxIteration(), parameters.getLineSearchStateVectorScalingStepFold());
            case StateVectorScalingMode.MAX_VOLTAGE_CHANGE -> new MaxVoltageChangeStateVectorScaling(parameters.getMaxVoltageChangeStateVectorScalingMaxDv(), parameters.getMaxVoltageChangeStateVectorScalingMaxDphi());
        };
    }

    public StateVectorScalingMode getMode();

    public void apply(double[] var1, EquationSystem<AcVariableType, AcEquationType> var2, ReportNode var3);

    public NewtonRaphsonStoppingCriteria.TestResult applyAfter(EquationSystem<AcVariableType, AcEquationType> var1, EquationVector<AcVariableType, AcEquationType> var2, TargetVector<AcVariableType, AcEquationType> var3, NewtonRaphsonStoppingCriteria var4, NewtonRaphsonStoppingCriteria.TestResult var5, ReportNode var6);
}

