/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcOuterLoop;
import com.powsybl.openloadflow.dc.DcOuterLoopContext;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.lf.outerloop.AbstractAreaInterchangeControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcAreaInterchangeControlOuterLoop
extends AbstractAreaInterchangeControlOuterLoop<DcVariableType, DcEquationType, DcLoadFlowParameters, DcLoadFlowContext, DcOuterLoopContext>
implements DcOuterLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcAreaInterchangeControlOuterLoop.class);

    public DcAreaInterchangeControlOuterLoop(ActivePowerDistribution activePowerDistribution, double slackBusPMaxMismatch, double areaInterchangePMaxMismatch) {
        super(activePowerDistribution, new DcNoAreaOuterLoop(), slackBusPMaxMismatch, areaInterchangePMaxMismatch, LOGGER);
    }

    @Override
    public double getSlackBusActivePowerMismatch(DcOuterLoopContext context) {
        List<LfBus> buses = context.getNetwork().getBuses();
        return DcLoadFlowEngine.getActivePowerMismatch(buses);
    }

    private static class DcNoAreaOuterLoop
    implements DcOuterLoop {
        private DcNoAreaOuterLoop() {
        }

        @Override
        public String getName() {
            return "DcNoAreaOuterLoop";
        }

        @Override
        public OuterLoopResult check(DcOuterLoopContext context, ReportNode reportNode) {
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
    }
}

