/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcTargetVector;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreator;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.lf.AbstractLoadFlowContext;
import com.powsybl.openloadflow.network.LfNetwork;

public class DcLoadFlowContext
extends AbstractLoadFlowContext<DcVariableType, DcEquationType, DcLoadFlowParameters> {
    private final boolean withEquationSystemListener;
    private DcTargetVector targetVector;

    public DcLoadFlowContext(LfNetwork network, DcLoadFlowParameters parameters) {
        this(network, parameters, true);
    }

    public DcLoadFlowContext(LfNetwork network, DcLoadFlowParameters parameters, boolean withEquationSystemListener) {
        super(network, parameters);
        this.withEquationSystemListener = withEquationSystemListener;
    }

    @Override
    public JacobianMatrix<DcVariableType, DcEquationType> getJacobianMatrix() {
        if (this.jacobianMatrix == null) {
            this.jacobianMatrix = new JacobianMatrix<DcVariableType, DcEquationType>(this.getEquationSystem(), ((DcLoadFlowParameters)this.parameters).getMatrixFactory());
        }
        return this.jacobianMatrix;
    }

    @Override
    public EquationSystem<DcVariableType, DcEquationType> getEquationSystem() {
        if (this.equationSystem == null) {
            this.equationSystem = new DcEquationSystemCreator(this.network, ((DcLoadFlowParameters)this.parameters).getEquationSystemCreationParameters()).create(this.withEquationSystemListener);
        }
        return this.equationSystem;
    }

    @Override
    public TargetVector<DcVariableType, DcEquationType> getTargetVector() {
        if (this.targetVector == null) {
            this.targetVector = new DcTargetVector(this.network, this.getEquationSystem());
        }
        return this.targetVector;
    }

    @Override
    public void close() {
        super.close();
        if (this.targetVector != null) {
            this.targetVector.close();
        }
    }
}

