/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.google.common.collect.Lists;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixException;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcAreaInterchangeControlOuterLoop;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowResult;
import com.powsybl.openloadflow.dc.DcOuterLoop;
import com.powsybl.openloadflow.dc.DcOuterLoopContext;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkLoader;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.util.Reports;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcLoadFlowEngine
implements LoadFlowEngine<DcVariableType, DcEquationType, DcLoadFlowParameters, DcLoadFlowResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcLoadFlowEngine.class);
    private final DcLoadFlowContext context;

    public DcLoadFlowEngine(DcLoadFlowContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public DcLoadFlowContext getContext() {
        return this.context;
    }

    public static double distributeSlack(LfNetwork network, Collection<LfBus> buses, LoadFlowParameters.BalanceType balanceType, boolean useActiveLimits) {
        double mismatch = DcLoadFlowEngine.getActivePowerMismatch(buses);
        ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(balanceType, false, useActiveLimits);
        ActivePowerDistribution.Result result = activePowerDistribution.run(network.getReferenceGenerator(), buses, mismatch);
        return mismatch - result.remainingMismatch();
    }

    public static double getActivePowerMismatch(Collection<LfBus> buses) {
        double mismatch = 0.0;
        for (LfBus b : buses) {
            if (b.isDisabled()) continue;
            mismatch += b.getGenerationTargetP() - b.getLoadTargetP();
        }
        return -mismatch;
    }

    public static void initStateVector(LfNetwork network, EquationSystem<DcVariableType, DcEquationType> equationSystem, VoltageInitializer initializer) {
        double[] x = new double[equationSystem.getIndex().getSortedVariablesToFind().size()];
        block5: for (Variable<DcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_PHI: {
                    x[v.getRow()] = initializer.getAngle(network.getBus(v.getElementNum()));
                    continue block5;
                }
                case BRANCH_ALPHA1: {
                    x[v.getRow()] = network.getBranch(v.getElementNum()).getPiModel().getA1();
                    continue block5;
                }
                case DUMMY_P: {
                    x[v.getRow()] = 0.0;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
        equationSystem.getStateVector().set(x);
    }

    public static void updateNetwork(LfNetwork network, EquationSystem<DcVariableType, DcEquationType> equationSystem, double[] x) {
        block5: for (Variable<DcVariableType> v : equationSystem.getIndex().getSortedVariablesToFind()) {
            switch (v.getType()) {
                case BUS_PHI: {
                    network.getBus(v.getElementNum()).setAngle(x[v.getRow()]);
                    continue block5;
                }
                case BRANCH_ALPHA1: {
                    network.getBranch(v.getElementNum()).getPiModel().setA1(x[v.getRow()]);
                    continue block5;
                }
                case DUMMY_P: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown variable type " + v.getType());
        }
    }

    private void runOuterLoop(DcOuterLoop outerLoop, DcOuterLoopContext outerLoopContext, RunningContext runningContext) {
        OuterLoopResult outerLoopResult;
        ReportNode olReportNode = Reports.createOuterLoopReporter(outerLoopContext.getNetwork().getReportNode(), outerLoop.getName());
        int outerLoopIteration = 0;
        do {
            outerLoopContext.setIteration(outerLoopIteration);
            outerLoopContext.setLoadFlowContext(this.context);
            outerLoopContext.setOuterLoopTotalIterations(runningContext.outerLoopTotalIterations);
            runningContext.lastOuterLoopResult = outerLoopResult = outerLoop.check(outerLoopContext, olReportNode);
            if (outerLoopResult.status() != OuterLoopStatus.UNSTABLE) continue;
            LOGGER.debug("Start outer loop '{}' iteration {}", (Object)outerLoop.getName(), (Object)outerLoopIteration);
            double[] targetVectorArray = (double[])this.context.getTargetVector().getArray().clone();
            runningContext.lastSolverSuccess = DcLoadFlowEngine.solve(targetVectorArray, this.context.getJacobianMatrix(), olReportNode);
            ++runningContext.solverTotalExecutions;
            if (runningContext.lastSolverSuccess) {
                this.context.getEquationSystem().getStateVector().set(targetVectorArray);
                DcLoadFlowEngine.updateNetwork(outerLoopContext.getNetwork(), this.context.getEquationSystem(), targetVectorArray);
            }
            ++outerLoopIteration;
            ++runningContext.outerLoopTotalIterations;
        } while (outerLoopResult.status() == OuterLoopStatus.UNSTABLE && runningContext.lastSolverSuccess && runningContext.outerLoopTotalIterations < ((DcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        if (outerLoopResult.status() != OuterLoopStatus.STABLE) {
            Reports.reportUnsuccessfulOuterLoop(olReportNode, outerLoopResult.status().name());
        }
    }

    public static boolean solve(double[] targetVectorArray, JacobianMatrix<DcVariableType, DcEquationType> jacobianMatrix, ReportNode reportNode) {
        try {
            jacobianMatrix.solveTransposed(targetVectorArray);
            return true;
        }
        catch (MatrixException e) {
            Reports.reportDcLfSolverFailure(reportNode, e.getMessage());
            LOGGER.error("Failed to solve linear system for DC load flow", (Throwable)e);
            return false;
        }
    }

    @Override
    public DcLoadFlowResult run() {
        LfNetwork network = this.context.getNetwork();
        ReportNode reportNode = network.getReportNode();
        EquationSystem<DcVariableType, DcEquationType> equationSystem = this.context.getEquationSystem();
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)this.context.getParameters();
        TargetVector<DcVariableType, DcEquationType> targetVector = this.context.getTargetVector();
        RunningContext runningContext = new RunningContext();
        List<DcOuterLoop> outerLoops = parameters.getOuterLoops();
        List<Pair> outerLoopsAndContexts = outerLoops.stream().map(outerLoop -> Pair.of((Object)outerLoop, (Object)new DcOuterLoopContext(network))).toList();
        for (Pair outerLoopAndContext : outerLoopsAndContexts) {
            DcOuterLoop outerLoop2 = (DcOuterLoop)outerLoopAndContext.getLeft();
            DcOuterLoopContext outerLoopContext = (DcOuterLoopContext)outerLoopAndContext.getRight();
            outerLoop2.initialize(outerLoopContext);
        }
        DcLoadFlowEngine.initStateVector(network, equationSystem, new UniformValueVoltageInitializer());
        double initialSlackBusActivePowerMismatch = DcLoadFlowEngine.getActivePowerMismatch(network.getBuses());
        double distributedActivePower = 0.0;
        boolean isAreaInterchangeControl = outerLoops.stream().anyMatch(DcAreaInterchangeControlOuterLoop.class::isInstance);
        if (parameters.isDistributedSlack() || isAreaInterchangeControl) {
            LfGenerator referenceGenerator;
            OpenLoadFlowParameters.SlackDistributionFailureBehavior behavior;
            LoadFlowParameters.BalanceType balanceType = parameters.getBalanceType();
            boolean useActiveLimits = parameters.getNetworkParameters().isUseActiveLimits();
            ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(balanceType, false, useActiveLimits);
            ActivePowerDistribution.Result result = activePowerDistribution.run(network, initialSlackBusActivePowerMismatch);
            if (isAreaInterchangeControl && network.hasArea()) {
                behavior = OpenLoadFlowParameters.SlackDistributionFailureBehavior.LEAVE_ON_SLACK_BUS;
                referenceGenerator = null;
            } else {
                behavior = parameters.getSlackDistributionFailureBehavior();
                referenceGenerator = this.context.getNetwork().getReferenceGenerator();
            }
            ActivePowerDistribution.ResultWithFailureBehaviorHandling resultWbh = ActivePowerDistribution.handleDistributionFailureBehavior(behavior, referenceGenerator, initialSlackBusActivePowerMismatch, result, "Failed to distribute slack bus active power mismatch, %.2f MW remains");
            double remainingMismatch = resultWbh.remainingMismatch();
            distributedActivePower = initialSlackBusActivePowerMismatch - remainingMismatch;
            if (Math.abs(remainingMismatch) > ((DcLoadFlowParameters)this.context.getParameters()).getSlackBusPMaxMismatch() / 100.0) {
                Reports.reportMismatchDistributionFailure(reportNode, remainingMismatch * 100.0);
            } else {
                if (Math.abs(remainingMismatch) > ActivePowerDistribution.P_RESIDUE_EPS) {
                    Reports.reportResidualDistributionMismatch(reportNode, remainingMismatch * 100.0);
                }
                ActivePowerDistribution.reportAndLogSuccess(reportNode, initialSlackBusActivePowerMismatch, resultWbh);
            }
            if (resultWbh.failed()) {
                runningContext.lastSolverSuccess = false;
                runningContext.lastOuterLoopResult = new OuterLoopResult("DistributedSlack", OuterLoopStatus.FAILED, resultWbh.failedMessage());
                Reports.reportDcLfComplete(reportNode, runningContext.lastSolverSuccess, runningContext.lastOuterLoopResult.status().name());
                return this.buildDcLoadFlowResult(network, runningContext, initialSlackBusActivePowerMismatch, distributedActivePower -= resultWbh.failedDistributedActivePower());
            }
        }
        double[] targetVectorArray = (double[])targetVector.getArray().clone();
        runningContext.lastSolverSuccess = DcLoadFlowEngine.solve(targetVectorArray, this.context.getJacobianMatrix(), reportNode);
        equationSystem.getStateVector().set(targetVectorArray);
        DcLoadFlowEngine.updateNetwork(network, equationSystem, targetVectorArray);
        if (runningContext.lastSolverSuccess) {
            int oldSolverTotalExecutions;
            block1: do {
                oldSolverTotalExecutions = runningContext.solverTotalExecutions;
                for (Pair outerLoopAndContext : outerLoopsAndContexts) {
                    this.runOuterLoop((DcOuterLoop)outerLoopAndContext.getLeft(), (DcOuterLoopContext)outerLoopAndContext.getRight(), runningContext);
                    if (runningContext.lastSolverSuccess && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((DcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations()) continue;
                    continue block1;
                }
            } while (runningContext.solverTotalExecutions > oldSolverTotalExecutions && runningContext.lastSolverSuccess && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((DcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        }
        if (runningContext.outerLoopTotalIterations >= ((DcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations()) {
            Reports.reportMaxOuterLoopIterations(reportNode, runningContext.outerLoopTotalIterations, true, LOGGER);
        }
        for (Pair outerLoopAndContext : Lists.reverse(outerLoopsAndContexts)) {
            DcOuterLoop outerLoop3 = (DcOuterLoop)outerLoopAndContext.getLeft();
            DcOuterLoopContext outerLoopContext = (DcOuterLoopContext)outerLoopAndContext.getRight();
            if (outerLoop3 instanceof DcAreaInterchangeControlOuterLoop) {
                DcAreaInterchangeControlOuterLoop activePowerDistributionOuterLoop = (DcAreaInterchangeControlOuterLoop)outerLoop3;
                distributedActivePower += activePowerDistributionOuterLoop.getDistributedActivePower(outerLoopContext);
            }
            outerLoop3.cleanup(outerLoopContext);
        }
        if (parameters.isSetVToNan()) {
            for (LfBus bus : network.getBuses()) {
                bus.setV(Double.NaN);
            }
        }
        Reports.reportDcLfComplete(reportNode, runningContext.lastSolverSuccess, runningContext.lastOuterLoopResult.status().name());
        return this.buildDcLoadFlowResult(network, runningContext, initialSlackBusActivePowerMismatch, distributedActivePower);
    }

    DcLoadFlowResult buildDcLoadFlowResult(LfNetwork network, RunningContext runningContext, double initialSlackBusActivePowerMismatch, double finalDistributedActivePower) {
        double distributedActivePower;
        double slackBusActivePowerMismatch;
        if (runningContext.lastSolverSuccess && runningContext.lastOuterLoopResult.status() == OuterLoopStatus.STABLE) {
            slackBusActivePowerMismatch = DcLoadFlowEngine.getActivePowerMismatch(network.getBuses());
            distributedActivePower = finalDistributedActivePower;
        } else {
            slackBusActivePowerMismatch = initialSlackBusActivePowerMismatch;
            distributedActivePower = 0.0;
        }
        DcLoadFlowResult result = new DcLoadFlowResult(network, runningContext.outerLoopTotalIterations, runningContext.lastSolverSuccess, runningContext.lastOuterLoopResult, slackBusActivePowerMismatch, distributedActivePower);
        LOGGER.info("DC loadflow complete on network {} (result={})", (Object)this.context.getNetwork(), (Object)result);
        return result;
    }

    public static <T> List<DcLoadFlowResult> run(T network, LfNetworkLoader<T> networkLoader, DcLoadFlowParameters parameters, ReportNode reportNode) {
        return LfNetwork.load(network, networkLoader, parameters.getNetworkParameters(), reportNode).stream().map(n -> {
            if (n.getValidity() == LfNetwork.Validity.VALID) {
                try (DcLoadFlowContext context = new DcLoadFlowContext((LfNetwork)n, parameters);){
                    DcLoadFlowResult dcLoadFlowResult = new DcLoadFlowEngine(context).run();
                    return dcLoadFlowResult;
                }
            }
            return DcLoadFlowResult.createNoCalculationResult(n);
        }).toList();
    }

    private static class RunningContext {
        private boolean lastSolverSuccess;
        private int solverTotalExecutions = 0;
        private int outerLoopTotalIterations = 0;
        private OuterLoopResult lastOuterLoopResult = OuterLoopResult.stable();

        private RunningContext() {
        }
    }
}

