/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.openloadflow.lf.AbstractLoadFlowResult;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfNetwork;

public class DcLoadFlowResult
extends AbstractLoadFlowResult {
    private final boolean solverSuccess;

    public static DcLoadFlowResult createNoCalculationResult(LfNetwork network) {
        return new DcLoadFlowResult(network, 0, false, OuterLoopResult.stable(), Double.NaN, Double.NaN);
    }

    public DcLoadFlowResult(LfNetwork network, int outerLoopIterations, boolean solverSuccess, OuterLoopResult outerLoopResult, double slackBusActivePowerMismatch, double distributedActivePower) {
        super(network, slackBusActivePowerMismatch, outerLoopIterations, outerLoopResult, distributedActivePower);
        this.solverSuccess = solverSuccess;
    }

    @Override
    public boolean isSuccess() {
        return this.solverSuccess && this.getOuterLoopResult().status() == OuterLoopStatus.STABLE;
    }

    @Override
    public LoadFlowResult.Status toComponentResultStatus() {
        if (this.network.getValidity() != LfNetwork.Validity.VALID) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.NO_CALCULATION, this.network.getValidity().toString());
        }
        if (this.getOuterLoopResult().status() == OuterLoopStatus.UNSTABLE) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.MAX_ITERATION_REACHED, "Reached outer loop max iterations limit. Last outer loop name: " + this.getOuterLoopResult().outerLoopName());
        }
        if (this.getOuterLoopResult().status() == OuterLoopStatus.FAILED) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Outer loop failed: " + this.getOuterLoopResult().statusText());
        }
        if (this.solverSuccess) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.CONVERGED, "Converged");
        }
        return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Solver Failed");
    }

    public String toString() {
        return "DcLoadFlowResult(outerLoopIterations=" + this.outerLoopIterations + ", solverSuccess=" + this.solverSuccess + ", outerLoopStatus=" + this.outerLoopResult.status() + ", slackBusActivePowerMismatch=" + this.slackBusActivePowerMismatch * 100.0 + ", distributedActivePower=" + this.distributedActivePower * 100.0 + ")";
    }
}

