/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc;

import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;

public class DcTargetVector
extends TargetVector<DcVariableType, DcEquationType> {
    public static void init(Equation<DcVariableType, DcEquationType> equation, LfNetwork network, double[] targets) {
        switch (equation.getType()) {
            case BUS_TARGET_P: {
                LfBus bus = network.getBus(equation.getElementNum());
                targets[equation.getColumn()] = bus.getTargetP();
                if (!bus.isSlack()) break;
                int n = equation.getColumn();
                targets[n] = targets[n] + DcLoadFlowEngine.getActivePowerMismatch(network.getBuses()) / (double)network.getSlackBuses().size();
                break;
            }
            case BUS_TARGET_PHI: 
            case DUMMY_TARGET_P: {
                targets[equation.getColumn()] = 0.0;
                break;
            }
            case BRANCH_TARGET_ALPHA1: {
                targets[equation.getColumn()] = network.getBranch(equation.getElementNum()).getPiModel().getA1();
                break;
            }
            case ZERO_PHI: {
                targets[equation.getColumn()] = LfBranch.getA(network.getBranch(equation.getElementNum()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state variable type: " + equation.getType());
            }
        }
        int n = equation.getColumn();
        targets[n] = targets[n] - equation.rhs();
    }

    public DcTargetVector(LfNetwork network, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        super(network, equationSystem, DcTargetVector::init);
    }
}

