/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.dc.equations.DcApproximationType;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.PiModelArray;
import java.util.List;
import java.util.Objects;

public abstract class AbstractClosedBranchDcFlowEquationTerm
extends AbstractElementEquationTerm<LfBranch, DcVariableType, DcEquationType> {
    protected final Variable<DcVariableType> ph1Var;
    protected final Variable<DcVariableType> ph2Var;
    protected final Variable<DcVariableType> a1Var;
    protected final List<Variable<DcVariableType>> variables;
    private final double power;
    private final boolean isPowerPreComputed;
    protected final boolean useTransformerRatio;
    protected DcApproximationType dcApproximationType;

    protected AbstractClosedBranchDcFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<DcVariableType> variableSet, boolean deriveA1, boolean useTransformerRatio, DcApproximationType dcApproximationType) {
        super(branch);
        PiModel piModel = branch.getPiModel();
        if (piModel.getX() == 0.0) {
            throw new IllegalArgumentException("Branch '" + branch.getId() + "' has reactance equal to zero");
        }
        this.ph1Var = variableSet.getVariable(bus1.getNum(), DcVariableType.BUS_PHI);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), DcVariableType.BUS_PHI);
        this.a1Var = deriveA1 ? variableSet.getVariable(branch.getNum(), DcVariableType.BRANCH_ALPHA1) : null;
        this.useTransformerRatio = useTransformerRatio;
        this.dcApproximationType = dcApproximationType;
        this.isPowerPreComputed = !(piModel instanceof PiModelArray);
        this.power = this.isPowerPreComputed ? AbstractClosedBranchDcFlowEquationTerm.computePower(useTransformerRatio, dcApproximationType, piModel) : Double.NaN;
        this.variables = this.a1Var != null ? List.of(this.ph1Var, this.ph2Var, this.a1Var) : List.of(this.ph1Var, this.ph2Var);
    }

    protected double getPower() {
        return this.isPowerPreComputed ? this.power : AbstractClosedBranchDcFlowEquationTerm.computePower(this.useTransformerRatio, this.dcApproximationType, ((LfBranch)this.element).getPiModel());
    }

    public static double computePower(boolean useTransformerRatio, DcApproximationType dcApproximationType, PiModel piModel) {
        double b = switch (dcApproximationType) {
            default -> throw new IncompatibleClassChangeError();
            case DcApproximationType.IGNORE_R -> 1.0 / piModel.getX();
            case DcApproximationType.IGNORE_G -> {
                double r = piModel.getR();
                double x = piModel.getX();
                yield x / (r * r + x * x);
            }
        };
        return b * (useTransformerRatio ? piModel.getR1() * 1.0 : 1.0);
    }

    public Variable<DcVariableType> getPh1Var() {
        return this.ph1Var;
    }

    public Variable<DcVariableType> getPh2Var() {
        return this.ph2Var;
    }

    @Override
    public double calculateSensi(DenseMatrix dx, int column) {
        Objects.requireNonNull(dx);
        double dph1 = dx.get(this.ph1Var.getRow(), column);
        double dph2 = dx.get(this.ph2Var.getRow(), column);
        double da1 = this.a1Var != null ? dx.get(this.a1Var.getRow(), column) : 0.0;
        return this.eval(dph1, dph2, da1) - this.eval(0.0, 0.0, 0.0);
    }

    protected double ph1(StateVector sv) {
        return sv.get(this.ph1Var.getRow());
    }

    protected double ph1() {
        return this.ph1(this.sv);
    }

    protected double ph2(StateVector sv) {
        return sv.get(this.ph2Var.getRow());
    }

    protected double ph2() {
        return this.ph2(this.sv);
    }

    protected abstract double eval(double var1, double var3, double var5);

    @Override
    public double eval() {
        return this.eval(this.ph1(), this.ph2(), this.a1());
    }

    protected double a1(StateVector sv) {
        return this.a1Var != null ? sv.get(this.a1Var.getRow()) : ((LfBranch)this.element).getPiModel().getA1();
    }

    protected double a1() {
        return this.a1(this.sv);
    }

    @Override
    public List<Variable<DcVariableType>> getVariables() {
        return this.variables;
    }

    @Override
    public boolean hasRhs() {
        return true;
    }
}

