/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.util.Evaluable;
import java.util.Objects;

public final class ClosedBranchDcCurrent
implements Evaluable {
    private final LfBranch branch;
    private final TwoSides side;
    private final double dcPowerFactor;

    public ClosedBranchDcCurrent(LfBranch branch, TwoSides side, double dcPowerFactor) {
        this.branch = Objects.requireNonNull(branch);
        this.side = Objects.requireNonNull(side);
        this.dcPowerFactor = dcPowerFactor;
    }

    @Override
    public double eval() {
        double p = this.side == TwoSides.ONE ? this.branch.getP1().eval() : this.branch.getP2().eval();
        return Math.abs(p) / this.dcPowerFactor;
    }
}

