/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.equations;

import com.powsybl.openloadflow.dc.equations.AbstractHvdcAcEmulationDcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;

public class HvdcAcEmulationSide2DCFlowEquationTerm
extends AbstractHvdcAcEmulationDcFlowEquationTerm {
    public HvdcAcEmulationSide2DCFlowEquationTerm(LfHvdc hvdc, LfBus bus1, LfBus bus2, VariableSet<DcVariableType> variableSet) {
        super(hvdc, bus1, bus2, variableSet);
    }

    @Override
    protected String getName() {
        return "dc_p_2_hvdc";
    }

    @Override
    public double eval() {
        return this.k * (this.ph2() - this.ph1()) - this.hvdc.getP0();
    }

    @Override
    public double der(Variable<DcVariableType> variable) {
        if (variable.equals(this.ph1Var)) {
            return -this.k;
        }
        if (variable.equals(this.ph2Var)) {
            return this.k;
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    public boolean hasRhs() {
        return true;
    }

    @Override
    public double rhs() {
        return -this.hvdc.getP0();
    }
}

