/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.fastdc;

import com.powsybl.commons.PowsyblException;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.Matrix;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractComputedElement {
    private int computedElementIndex = -1;
    private int localIndex = -1;
    private double alphaForWoodburyComputation = Double.NaN;
    private final LfBranch lfBranch;
    private final ClosedBranchSide1DcFlowEquationTerm branchEquation;

    protected AbstractComputedElement(LfBranch lfBranch, ClosedBranchSide1DcFlowEquationTerm branchEquation) {
        this.lfBranch = lfBranch;
        this.branchEquation = branchEquation;
    }

    public int getComputedElementIndex() {
        return this.computedElementIndex;
    }

    public void setComputedElementIndex(int index) {
        this.computedElementIndex = index;
    }

    public int getLocalIndex() {
        return this.localIndex;
    }

    protected void setLocalIndex(int index) {
        this.localIndex = index;
    }

    public double getAlphaForWoodburyComputation() {
        return this.alphaForWoodburyComputation;
    }

    public void setAlphaForWoodburyComputation(double alphaForPostContingencyStates) {
        this.alphaForWoodburyComputation = alphaForPostContingencyStates;
    }

    public LfBranch getLfBranch() {
        return this.lfBranch;
    }

    public ClosedBranchSide1DcFlowEquationTerm getLfBranchEquation() {
        return this.branchEquation;
    }

    public static void setComputedElementIndexes(Collection<? extends AbstractComputedElement> elements) {
        AtomicInteger index = new AtomicInteger(0);
        HashMap<LfBranch, Integer> branchesToRhsIndex = new HashMap<LfBranch, Integer>();
        for (AbstractComputedElement abstractComputedElement : elements) {
            LfBranch elementLfBranch = abstractComputedElement.getLfBranch();
            Integer elementIndex = branchesToRhsIndex.computeIfAbsent(elementLfBranch, lfBranch -> index.getAndIncrement());
            abstractComputedElement.setComputedElementIndex(elementIndex);
        }
    }

    public static void setLocalIndexes(Collection<? extends AbstractComputedElement> elements) {
        int index = 0;
        for (AbstractComputedElement abstractComputedElement : elements) {
            abstractComputedElement.setLocalIndex(index++);
        }
    }

    private static void fillRhs(EquationSystem<DcVariableType, DcEquationType> equationSystem, Collection<? extends AbstractComputedElement> computedElements, Matrix rhs) {
        for (AbstractComputedElement abstractComputedElement : computedElements) {
            Equation<DcVariableType, DcEquationType> p;
            LfBranch lfBranch = abstractComputedElement.getLfBranch();
            if (lfBranch.getBus1() == null || lfBranch.getBus2() == null) continue;
            LfBus bus1 = lfBranch.getBus1();
            LfBus bus2 = lfBranch.getBus2();
            if (bus1.isSlack()) {
                p = equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
                rhs.set(p.getColumn(), abstractComputedElement.getComputedElementIndex(), -1.0);
                continue;
            }
            if (bus2.isSlack()) {
                p = equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
                rhs.set(p.getColumn(), abstractComputedElement.getComputedElementIndex(), 1.0);
                continue;
            }
            Equation<DcVariableType, DcEquationType> p1 = equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
            Equation<DcVariableType, DcEquationType> p2 = equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
            rhs.set(p1.getColumn(), abstractComputedElement.getComputedElementIndex(), 1.0);
            rhs.set(p2.getColumn(), abstractComputedElement.getComputedElementIndex(), -1.0);
        }
    }

    public static DenseMatrix initRhs(EquationSystem<DcVariableType, DcEquationType> equationSystem, Collection<? extends AbstractComputedElement> elements) {
        int equationCount;
        int maxElements;
        int columnCount = (int)elements.stream().map(AbstractComputedElement::getLfBranch).filter(Objects::nonNull).distinct().count();
        if (columnCount > (maxElements = Integer.MAX_VALUE / ((equationCount = equationSystem.getIndex().getSortedEquationsToSolve().size()) * 8))) {
            throw new PowsyblException("Too many elements " + columnCount + ", maximum is " + maxElements + " for a system with " + equationCount + " equations");
        }
        DenseMatrix rhs = new DenseMatrix(equationCount, columnCount);
        AbstractComputedElement.fillRhs(equationSystem, elements, (Matrix)rhs);
        return rhs;
    }

    public static DenseMatrix calculateElementsStates(DcLoadFlowContext loadFlowContext, Collection<? extends AbstractComputedElement> computedElements) {
        DenseMatrix elementsStates = AbstractComputedElement.initRhs(loadFlowContext.getEquationSystem(), computedElements);
        loadFlowContext.getJacobianMatrix().solveTransposed(elementsStates);
        return elementsStates;
    }

    public abstract void applyToConnectivity(GraphConnectivity<LfBus, LfBranch> var1);
}

