/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.fastdc;

import com.powsybl.contingency.BranchContingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.dc.fastdc.AbstractComputedElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedContingencyElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedSwitchBranchElement;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.network.action.LfAction;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectivityBreakAnalysis {
    private static final double CONNECTIVITY_LOSS_THRESHOLD = 1.0E-6;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectivityBreakAnalysis.class);

    private ConnectivityBreakAnalysis() {
    }

    private static void detectPotentialConnectivityBreak(LfNetwork lfNetwork, DenseMatrix contingencyStates, List<PropagatedContingency> contingencies, Map<String, ComputedContingencyElement> contingencyElementByBranch, EquationSystem<DcVariableType, DcEquationType> equationSystem, List<PropagatedContingency> nonBreakingConnectivityContingencies, List<PropagatedContingency> potentiallyBreakingConnectivityContingencies) {
        for (PropagatedContingency contingency : contingencies) {
            if (ConnectivityBreakAnalysis.isConnectivityPotentiallyModifiedByContingencyAndOperatorStrategy(lfNetwork, new States(contingencyStates, DenseMatrix.EMPTY), contingency, contingencyElementByBranch, Collections.emptyList(), Collections.emptyMap(), equationSystem)) {
                potentiallyBreakingConnectivityContingencies.add(contingency);
                continue;
            }
            nonBreakingConnectivityContingencies.add(contingency);
        }
    }

    private static boolean isConnectivityPotentiallyModifiedByContingencyAndOperatorStrategy(LfNetwork lfNetwork, States states, PropagatedContingency contingency, Map<String, ComputedContingencyElement> contingencyElementByBranch, List<LfAction> operatorStrategyLfActions, Map<LfAction, AbstractComputedElement> actionElementByBranch, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        List<ComputedContingencyElement> contingencyElements = contingency.getBranchIdsToOpen().keySet().stream().map(contingencyElementByBranch::get).collect(Collectors.toList());
        List<AbstractComputedElement> actionElements = operatorStrategyLfActions.stream().map(actionElementByBranch::get).filter(actionElement -> {
            ComputedSwitchBranchElement computedSwitchBranchElement;
            return actionElement instanceof ComputedSwitchBranchElement && !(computedSwitchBranchElement = (ComputedSwitchBranchElement)actionElement).isEnabled();
        }).collect(Collectors.toList());
        return ConnectivityBreakAnalysis.isGroupOfElementsBreakingConnectivity(lfNetwork, states.contingencyStates(), contingencyElements, states.actionStates(), actionElements, equationSystem);
    }

    private static boolean isGroupOfElementsBreakingConnectivity(LfNetwork lfNetwork, DenseMatrix contingenciesStates, List<ComputedContingencyElement> contingencyElements, DenseMatrix actionStates, List<AbstractComputedElement> actionElements, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        List computedElements = Stream.concat(contingencyElements.stream(), actionElements.stream()).toList();
        for (AbstractComputedElement element : computedElements) {
            double sum = 0.0;
            for (AbstractComputedElement element2 : computedElements) {
                LfBranch branch = lfNetwork.getBranchById(element2.getLfBranch().getId());
                ClosedBranchSide1DcFlowEquationTerm p = equationSystem.getEquationTerm(ElementType.BRANCH, branch.getNum(), ClosedBranchSide1DcFlowEquationTerm.class);
                DenseMatrix elementMatrix = element2 instanceof ComputedContingencyElement ? contingenciesStates : actionStates;
                double value = Math.abs(p.calculateSensi(elementMatrix, element.getComputedElementIndex()));
                sum += value;
            }
            if (!(sum > 0.999999)) continue;
            return true;
        }
        return false;
    }

    private static List<ConnectivityAnalysisResult> computeConnectivityData(LfNetwork lfNetwork, List<PropagatedContingency> potentiallyBreakingConnectivityContingencies, Map<String, ComputedContingencyElement> contingencyElementByBranch, List<PropagatedContingency> nonBreakingConnectivityContingencies) {
        if (potentiallyBreakingConnectivityContingencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConnectivityAnalysisResult> connectivityAnalysisResults = new ArrayList<ConnectivityAnalysisResult>();
        for (PropagatedContingency propagatedContingency : potentiallyBreakingConnectivityContingencies) {
            ConnectivityAnalysisResult connectivityAnalysisResult = ConnectivityBreakAnalysis.computeConnectivityAnalysisResult(lfNetwork, propagatedContingency, contingencyElementByBranch, Collections.emptyList(), Collections.emptyMap());
            if (connectivityAnalysisResult != null) {
                connectivityAnalysisResults.add(connectivityAnalysisResult);
                continue;
            }
            nonBreakingConnectivityContingencies.add(propagatedContingency);
        }
        return connectivityAnalysisResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectivityAnalysisResult computeConnectivityAnalysisResult(LfNetwork lfNetwork, PropagatedContingency contingency, Map<String, ComputedContingencyElement> contingencyElementByBranch, List<LfAction> lfActions, Map<LfAction, AbstractComputedElement> actionElementByBranch) {
        GraphConnectivity<LfBus, LfBranch> connectivity = lfNetwork.getConnectivity();
        List<AbstractComputedElement> modifyingConnectivityCandidates = Stream.concat(contingency.getBranchIdsToOpen().keySet().stream().map(contingencyElementByBranch::get), lfActions.stream().map(actionElementByBranch::get)).sorted(Comparator.comparing(element -> element.getLfBranch().getId())).toList();
        ConnectivityAnalysisResult connectivityAnalysisResult = null;
        connectivity.startTemporaryChanges();
        try {
            modifyingConnectivityCandidates.forEach(computedElement -> computedElement.applyToConnectivity(connectivity));
            LinkedHashSet breakingConnectivityElements = modifyingConnectivityCandidates.stream().filter(element -> ConnectivityBreakAnalysis.isBreakingConnectivity(connectivity, element)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (!breakingConnectivityElements.isEmpty()) {
                Set<String> elementsToReconnect = ConnectivityBreakAnalysis.computeElementsToReconnect(connectivity, breakingConnectivityElements);
                int createdSynchronousComponents = connectivity.getNbConnectedComponents() - 1;
                Set<LfBus> disabledBuses = connectivity.getVerticesRemovedFromMainComponent();
                Set<LfHvdc> hvdcsWithoutPower = PropagatedContingency.getHvdcsWithoutPower(lfNetwork, disabledBuses, connectivity);
                connectivityAnalysisResult = new ConnectivityAnalysisResult(contingency, lfNetwork, elementsToReconnect, new DisabledElements(disabledBuses, connectivity.getEdgesRemovedFromMainComponent(), hvdcsWithoutPower), connectivity.getConnectedComponent(lfNetwork.getSlackBus()), createdSynchronousComponents, lfActions);
            }
        }
        finally {
            connectivity.undoTemporaryChanges();
        }
        return connectivityAnalysisResult;
    }

    private static boolean isBreakingConnectivity(GraphConnectivity<LfBus, LfBranch> connectivity, AbstractComputedElement element) {
        LfBranch lfBranch = element.getLfBranch();
        return connectivity.getComponentNumber(lfBranch.getBus1()) != connectivity.getComponentNumber(lfBranch.getBus2());
    }

    private static Set<String> computeElementsToReconnect(GraphConnectivity<LfBus, LfBranch> connectivity, Set<AbstractComputedElement> breakingConnectivityElements) {
        LinkedHashSet<String> elementsToReconnect = new LinkedHashSet<String>();
        ArrayList<Set> reconnectedCc = new ArrayList<Set>();
        for (AbstractComputedElement element : breakingConnectivityElements) {
            Set recCc2;
            int cc1 = connectivity.getComponentNumber(element.getLfBranch().getBus1());
            int cc2 = connectivity.getComponentNumber(element.getLfBranch().getBus2());
            Set recCc1 = reconnectedCc.stream().filter(s -> s.contains(cc1)).findFirst().orElseGet(() -> new HashSet<Integer>(List.of(Integer.valueOf(cc1))));
            if (recCc1 == (recCc2 = reconnectedCc.stream().filter(s -> s.contains(cc2)).findFirst().orElseGet(() -> Set.of(Integer.valueOf(cc2))))) continue;
            elementsToReconnect.add(element.getLfBranch().getId());
            reconnectedCc.remove(recCc2);
            if (recCc1.size() == 1) {
                reconnectedCc.add(recCc1);
            }
            recCc1.addAll(recCc2);
        }
        if (reconnectedCc.size() != 1 || ((Set)reconnectedCc.get(0)).size() != connectivity.getNbConnectedComponents()) {
            LOGGER.error("Elements to reconnect computed do not reconnect all connected components together");
        }
        return elementsToReconnect;
    }

    private static Map<String, ComputedContingencyElement> createContingencyElementsIndexByBranchId(List<PropagatedContingency> contingencies, LfNetwork lfNetwork, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        Map contingencyElementByBranch = contingencies.stream().flatMap(contingency -> contingency.getBranchIdsToOpen().keySet().stream()).map(branch -> new ComputedContingencyElement((ContingencyElement)new BranchContingency(branch), lfNetwork, equationSystem)).filter(element -> element.getLfBranchEquation() != null).collect(Collectors.toMap(computedContingencyElement -> computedContingencyElement.getElement().getId(), computedContingencyElement -> computedContingencyElement, (existing, replacement) -> existing, LinkedHashMap::new));
        AbstractComputedElement.setComputedElementIndexes(contingencyElementByBranch.values());
        return contingencyElementByBranch;
    }

    public static ConnectivityBreakAnalysisResults run(DcLoadFlowContext loadFlowContext, List<PropagatedContingency> contingencies) {
        Map<String, ComputedContingencyElement> contingencyElementByBranch = ConnectivityBreakAnalysis.createContingencyElementsIndexByBranchId(contingencies, loadFlowContext.getNetwork(), loadFlowContext.getEquationSystem());
        DenseMatrix contingenciesStates = AbstractComputedElement.calculateElementsStates(loadFlowContext, contingencyElementByBranch.values());
        ArrayList<PropagatedContingency> nonBreakingConnectivityContingencies = new ArrayList<PropagatedContingency>();
        ArrayList<PropagatedContingency> potentiallyBreakingConnectivityContingencies = new ArrayList<PropagatedContingency>();
        ConnectivityBreakAnalysis.detectPotentialConnectivityBreak(loadFlowContext.getNetwork(), contingenciesStates, contingencies, contingencyElementByBranch, loadFlowContext.getEquationSystem(), nonBreakingConnectivityContingencies, potentiallyBreakingConnectivityContingencies);
        LOGGER.info("After sensitivity based connectivity analysis, {} contingencies do not break connectivity, {} contingencies potentially break connectivity", (Object)nonBreakingConnectivityContingencies.size(), (Object)potentiallyBreakingConnectivityContingencies.size());
        List<ConnectivityAnalysisResult> connectivityAnalysisResults = ConnectivityBreakAnalysis.computeConnectivityData(loadFlowContext.getNetwork(), potentiallyBreakingConnectivityContingencies, contingencyElementByBranch, nonBreakingConnectivityContingencies);
        LOGGER.info("After graph based connectivity analysis, {} contingencies do not break connectivity, {} contingencies break connectivity", (Object)nonBreakingConnectivityContingencies.size(), (Object)connectivityAnalysisResults.size());
        return new ConnectivityBreakAnalysisResults(nonBreakingConnectivityContingencies, connectivityAnalysisResults, contingenciesStates, contingencyElementByBranch);
    }

    public static ConnectivityAnalysisResult processPostContingencyAndPostOperatorStrategyConnectivityAnalysisResult(DcLoadFlowContext loadFlowContext, ConnectivityAnalysisResult postContingencyConnectivityAnalysisResult, Map<String, ComputedContingencyElement> contingencyElementByBranch, DenseMatrix contingenciesStates, List<LfAction> lfActions, Map<LfAction, AbstractComputedElement> actionElementsIndexByLfAction, DenseMatrix actionsStates) {
        PropagatedContingency contingency;
        boolean hasAnyTopologicalAction = lfActions.stream().anyMatch(lfAction -> lfAction instanceof AbstractLfBranchAction);
        if (!hasAnyTopologicalAction) {
            return postContingencyConnectivityAnalysisResult.withLfActions(lfActions);
        }
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        boolean isConnectivityPotentiallyModified = ConnectivityBreakAnalysis.isConnectivityPotentiallyModifiedByContingencyAndOperatorStrategy(lfNetwork, new States(contingenciesStates, actionsStates), contingency = postContingencyConnectivityAnalysisResult.getPropagatedContingency(), contingencyElementByBranch, lfActions, actionElementsIndexByLfAction, loadFlowContext.getEquationSystem());
        if (!isConnectivityPotentiallyModified) {
            return postContingencyConnectivityAnalysisResult.withLfActions(lfActions);
        }
        ConnectivityAnalysisResult postContingencyAndOperatorStrategyConnectivityAnalysisResult = ConnectivityBreakAnalysis.computeConnectivityAnalysisResult(lfNetwork, contingency, contingencyElementByBranch, lfActions, actionElementsIndexByLfAction);
        LOGGER.info("After graph based connectivity analysis, the contingency and associated actions {} break connectivity", (Object)(postContingencyAndOperatorStrategyConnectivityAnalysisResult != null ? "" : "do not"));
        return postContingencyAndOperatorStrategyConnectivityAnalysisResult;
    }

    private record States(DenseMatrix contingencyStates, DenseMatrix actionStates) {
    }

    public static final class ConnectivityAnalysisResult {
        private final PropagatedContingency propagatedContingency;
        private final LfNetwork network;
        private final Set<String> elementsToReconnect;
        private final Set<LfBus> slackConnectedComponent;
        private final int createdSynchronousComponents;
        private final DisabledElements disabledElements;
        private final List<LfAction> lfActions;

        public ConnectivityAnalysisResult(PropagatedContingency nonBreakingConnectivityContingency, LfNetwork network) {
            this(nonBreakingConnectivityContingency, Collections.emptyList(), network);
        }

        public ConnectivityAnalysisResult(PropagatedContingency nonBreakingConnectivityContingency, List<LfAction> lfActions, LfNetwork network) {
            this(nonBreakingConnectivityContingency, network, Collections.emptySet(), DisabledElements.NO_DISABLED_ELEMENTS, Collections.emptySet(), 0, lfActions);
        }

        public ConnectivityAnalysisResult(PropagatedContingency propagatedContingency, LfNetwork network, Set<String> elementsToReconnect, DisabledElements disabledElements, Set<LfBus> slackConnectedComponentBuses, int createdSynchronousComponents, List<LfAction> lfActions) {
            this.propagatedContingency = Objects.requireNonNull(propagatedContingency);
            this.network = Objects.requireNonNull(network);
            this.elementsToReconnect = elementsToReconnect;
            this.disabledElements = disabledElements;
            this.slackConnectedComponent = slackConnectedComponentBuses;
            this.createdSynchronousComponents = createdSynchronousComponents;
            this.lfActions = lfActions;
        }

        public PropagatedContingency getPropagatedContingency() {
            return this.propagatedContingency;
        }

        public Set<String> getElementsToReconnect() {
            return this.elementsToReconnect;
        }

        public Set<LfBus> getDisabledBuses() {
            return this.disabledElements.disabledBuses;
        }

        public Set<LfBus> getSlackConnectedComponent() {
            return this.slackConnectedComponent;
        }

        public Set<LfBranch> getPartialDisabledBranches() {
            return this.disabledElements.partialDisabledBranches;
        }

        public Set<LfHvdc> getHvdcsWithoutPower() {
            return this.disabledElements.hvdcsWithoutPower;
        }

        public List<LfAction> getLfActions() {
            return this.lfActions;
        }

        public Optional<LfContingency> toLfContingency() {
            PropagatedContingency.ContingencyConnectivityLossImpactAnalysis analysis = (network, contingencyId, branchesToOpen, relocateSlackBus) -> new PropagatedContingency.ContingencyConnectivityLossImpact(this.createdSynchronousComponents, this.disabledElements.disabledBuses, this.disabledElements.hvdcsWithoutPower);
            return this.propagatedContingency.toLfContingency(this.network, false, analysis);
        }

        public ConnectivityAnalysisResult withLfActions(List<LfAction> lfActions) {
            return new ConnectivityAnalysisResult(this.propagatedContingency, this.network, this.elementsToReconnect, this.disabledElements, this.slackConnectedComponent, this.createdSynchronousComponents, lfActions);
        }
    }

    public record DisabledElements(Set<LfBus> disabledBuses, Set<LfBranch> partialDisabledBranches, Set<LfHvdc> hvdcsWithoutPower) {
        public static final DisabledElements NO_DISABLED_ELEMENTS = new DisabledElements(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public record ConnectivityBreakAnalysisResults(List<PropagatedContingency> nonBreakingConnectivityContingencies, List<ConnectivityAnalysisResult> connectivityAnalysisResults, DenseMatrix contingenciesStates, Map<String, ComputedContingencyElement> contingencyElementByBranch) {
    }
}

