/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.dc.fastdc;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.equations.AbstractClosedBranchDcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.fastdc.AbstractComputedElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedContingencyElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedSwitchBranchElement;
import com.powsybl.openloadflow.dc.fastdc.ComputedTapPositionChangeElement;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TapPositionChange;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.network.action.AbstractLfTapChangerAction;
import com.powsybl.openloadflow.network.action.LfAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;

public class WoodburyEngine {
    private final DcEquationSystemCreationParameters creationParameters;
    private final List<ComputedContingencyElement> contingencyElements;
    private final DenseMatrix contingenciesStates;
    private final List<AbstractComputedElement> actionElements;
    private final DenseMatrix actionsStates;

    public WoodburyEngine(DcEquationSystemCreationParameters creationParameters, List<ComputedContingencyElement> contingencyElements, DenseMatrix contingenciesStates) {
        this.creationParameters = Objects.requireNonNull(creationParameters);
        this.contingencyElements = Objects.requireNonNull(contingencyElements);
        this.contingenciesStates = Objects.requireNonNull(contingenciesStates);
        this.actionElements = Collections.emptyList();
        this.actionsStates = DenseMatrix.EMPTY;
    }

    public WoodburyEngine(DcEquationSystemCreationParameters creationParameters, List<ComputedContingencyElement> contingencyElements, DenseMatrix contingenciesStates, List<AbstractComputedElement> actionElements, DenseMatrix actionsStates) {
        this.creationParameters = Objects.requireNonNull(creationParameters);
        this.contingencyElements = Objects.requireNonNull(contingencyElements);
        this.contingenciesStates = Objects.requireNonNull(contingenciesStates);
        this.actionElements = Objects.requireNonNull(actionElements);
        this.actionsStates = Objects.requireNonNull(actionsStates);
    }

    public static double[] runDcLoadFlowWithModifiedTargetVector(DcLoadFlowContext loadFlowContext, DisabledNetwork disabledNetwork, ReportNode reportNode) {
        return WoodburyEngine.runDcLoadFlowWithModifiedTargetVector(loadFlowContext, disabledNetwork, reportNode, Collections.emptyList());
    }

    public static double[] runDcLoadFlowWithModifiedTargetVector(DcLoadFlowContext loadFlowContext, DisabledNetwork disabledNetwork, ReportNode reportNode, List<LfAction> lfActions) {
        boolean succeeded;
        SequencedCollection<LfBus> remainingBuses;
        if (disabledNetwork.getBuses().isEmpty()) {
            remainingBuses = loadFlowContext.getNetwork().getBuses();
        } else {
            remainingBuses = new LinkedHashSet<LfBus>(loadFlowContext.getNetwork().getBuses());
            remainingBuses.removeAll(disabledNetwork.getBuses());
        }
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
        if (parameters.isDistributedSlack()) {
            DcLoadFlowEngine.distributeSlack(loadFlowContext.getNetwork(), remainingBuses, parameters.getBalanceType(), parameters.getNetworkParameters().isUseActiveLimits());
        }
        double[] targetVectorArray = (double[])loadFlowContext.getTargetVector().getArray().clone();
        if (!disabledNetwork.getBuses().isEmpty()) {
            disabledNetwork.getBuses().stream().flatMap(lfBus -> loadFlowContext.getEquationSystem().getEquation(lfBus.getNum(), DcEquationType.BUS_TARGET_P).stream()).map(Equation::getColumn).forEach(column -> {
                targetVectorArray[column.intValue()] = 0.0;
            });
        }
        if (!disabledNetwork.getBranches().isEmpty()) {
            disabledNetwork.getBranches().stream().flatMap(lfBranch -> loadFlowContext.getEquationSystem().getEquation(lfBranch.getNum(), DcEquationType.BRANCH_TARGET_ALPHA1).stream()).map(Equation::getColumn).forEach(column -> {
                targetVectorArray[column.intValue()] = 0.0;
            });
        }
        if (!lfActions.isEmpty()) {
            lfActions.stream().filter(AbstractLfTapChangerAction.class::isInstance).map(action -> ((AbstractLfTapChangerAction)action).getChange()).filter(Objects::nonNull).forEach(tapPositionChange -> {
                LfBranch lfBranch = tapPositionChange.getBranch();
                loadFlowContext.getEquationSystem().getEquation(lfBranch.getNum(), DcEquationType.BRANCH_TARGET_ALPHA1).ifPresent(dcVariableTypeDcEquationTypeEquation -> {
                    int column = dcVariableTypeDcEquationTypeEquation.getColumn();
                    targetVectorArray[column] = tapPositionChange.getNewPiModel().getA1();
                });
            });
            lfActions.stream().filter(AbstractLfBranchAction.class::isInstance).map(lfAction -> ((AbstractLfBranchAction)lfAction).getDisabledBranch()).filter(Objects::nonNull).flatMap(lfBranch -> loadFlowContext.getEquationSystem().getEquation(lfBranch.getNum(), DcEquationType.BRANCH_TARGET_ALPHA1).stream()).map(Equation::getColumn).forEach(column -> {
                targetVectorArray[column.intValue()] = 0.0;
            });
        }
        if (!(succeeded = DcLoadFlowEngine.solve(targetVectorArray, loadFlowContext.getJacobianMatrix(), reportNode))) {
            throw new PowsyblException("DC solver failed");
        }
        return targetVectorArray;
    }

    private double calculatePower(LfBranch lfBranch) {
        return this.calculatePower(lfBranch.getPiModel());
    }

    private double calculatePower(PiModel piModel) {
        return AbstractClosedBranchDcFlowEquationTerm.computePower(this.creationParameters.isUseTransformerRatio(), this.creationParameters.getDcApproximationType(), piModel);
    }

    private double getAlphaRhsValue(DenseMatrix states, ClosedBranchSide1DcFlowEquationTerm p1, int columnState, AbstractComputedElement computedElement) {
        double newAlpha = 0.0;
        if (computedElement instanceof ComputedTapPositionChangeElement) {
            ComputedTapPositionChangeElement computedTapPositionChangeElement = (ComputedTapPositionChangeElement)computedElement;
            TapPositionChange tapPositionChange = computedTapPositionChangeElement.getTapPositionChange();
            PiModel newPiModel = tapPositionChange.getNewPiModel();
            newAlpha = newPiModel.getA1();
        }
        return states.get(p1.getPh1Var().getRow(), columnState) - states.get(p1.getPh2Var().getRow(), columnState) + newAlpha;
    }

    private double computeDeltaXForDiagonalValues(LfBranch lfBranch, AbstractComputedElement element) {
        double oldPower = 0.0;
        double newPower = 0.0;
        if (element instanceof ComputedTapPositionChangeElement) {
            ComputedTapPositionChangeElement tapChangeElement = (ComputedTapPositionChangeElement)element;
            TapPositionChange tapPositionChange = tapChangeElement.getTapPositionChange();
            newPower = this.calculatePower(tapPositionChange.getNewPiModel());
            oldPower = this.calculatePower(lfBranch);
        } else if (element instanceof ComputedSwitchBranchElement) {
            ComputedSwitchBranchElement switchElement = (ComputedSwitchBranchElement)element;
            if (switchElement.isEnabled()) {
                newPower = this.calculatePower(lfBranch);
            } else {
                oldPower = this.calculatePower(lfBranch);
            }
        } else {
            throw new IllegalStateException("Unexpected computed element type");
        }
        return 1.0 / (oldPower - newPower);
    }

    private double getAlphaMatrixValue(LfBranch lfBranch, ClosedBranchSide1DcFlowEquationTerm p1, AbstractComputedElement element, boolean onDiagonal) {
        if (element instanceof ComputedContingencyElement) {
            double deltaX = onDiagonal ? 1.0 / this.calculatePower(lfBranch) : 0.0;
            return deltaX - (this.contingenciesStates.get(p1.getPh1Var().getRow(), element.getComputedElementIndex()) - this.contingenciesStates.get(p1.getPh2Var().getRow(), element.getComputedElementIndex()));
        }
        double deltaX = onDiagonal ? this.computeDeltaXForDiagonalValues(lfBranch, element) : 0.0;
        return deltaX - (this.actionsStates.get(p1.getPh1Var().getRow(), element.getComputedElementIndex()) - this.actionsStates.get(p1.getPh2Var().getRow(), element.getComputedElementIndex()));
    }

    private void setAlphas(DenseMatrix states, int columnState) {
        if (this.contingencyElements.size() + this.actionElements.size() == 1) {
            AbstractComputedElement element2 = this.actionElements.isEmpty() ? (AbstractComputedElement)this.contingencyElements.iterator().next() : this.actionElements.iterator().next();
            LfBranch lfBranch = element2.getLfBranch();
            ClosedBranchSide1DcFlowEquationTerm p1 = element2.getLfBranchEquation();
            double a = this.getAlphaMatrixValue(lfBranch, p1, element2, true);
            double b = this.getAlphaRhsValue(states, p1, columnState, element2);
            element2.setAlphaForWoodburyComputation(b / a);
        } else {
            double value;
            int j;
            ClosedBranchSide1DcFlowEquationTerm p1;
            LfBranch lfBranch;
            int i;
            AbstractComputedElement.setLocalIndexes(this.contingencyElements);
            AbstractComputedElement.setLocalIndexes(this.actionElements);
            int size = this.contingencyElements.size() + this.actionElements.size();
            DenseMatrix rhs = new DenseMatrix(size, 1);
            DenseMatrix matrix = new DenseMatrix(size, size);
            for (ComputedContingencyElement contingencyElement : this.contingencyElements) {
                i = contingencyElement.getLocalIndex();
                lfBranch = contingencyElement.getLfBranch();
                p1 = contingencyElement.getLfBranchEquation();
                rhs.set(i, 0, this.getAlphaRhsValue(states, p1, columnState, contingencyElement));
                Iterator<AbstractComputedElement> iterator = this.contingencyElements.iterator();
                while (iterator.hasNext()) {
                    ComputedContingencyElement contingencyElement2;
                    j = (contingencyElement2 = iterator.next()).getLocalIndex();
                    value = this.getAlphaMatrixValue(lfBranch, p1, contingencyElement2, i == j);
                    matrix.set(i, j, value);
                }
                for (AbstractComputedElement actionElement : this.actionElements) {
                    j = this.contingencyElements.size() + actionElement.getLocalIndex();
                    value = this.getAlphaMatrixValue(lfBranch, p1, actionElement, false);
                    matrix.set(i, j, value);
                }
            }
            for (AbstractComputedElement actionElement : this.actionElements) {
                i = this.contingencyElements.size() + actionElement.getLocalIndex();
                lfBranch = actionElement.getLfBranch();
                p1 = actionElement.getLfBranchEquation();
                rhs.set(i, 0, this.getAlphaRhsValue(states, p1, columnState, actionElement));
                for (ComputedContingencyElement contingencyElement : this.contingencyElements) {
                    j = contingencyElement.getLocalIndex();
                    value = this.getAlphaMatrixValue(lfBranch, p1, contingencyElement, false);
                    matrix.set(i, j, value);
                }
                for (AbstractComputedElement actionElement2 : this.actionElements) {
                    j = this.contingencyElements.size() + actionElement2.getLocalIndex();
                    value = this.getAlphaMatrixValue(lfBranch, p1, actionElement2, i == j);
                    matrix.set(i, j, value);
                }
            }
            try (LUDecomposition lu = matrix.decomposeLU();){
                lu.solve(rhs);
            }
            this.contingencyElements.forEach(element -> element.setAlphaForWoodburyComputation(rhs.get(element.getLocalIndex(), 0)));
            this.actionElements.forEach(element -> element.setAlphaForWoodburyComputation(rhs.get(this.contingencyElements.size() + element.getLocalIndex(), 0)));
        }
    }

    public void toPostContingencyStates(DenseMatrix preContingencyStates) {
        Objects.requireNonNull(preContingencyStates);
        for (int columnIndex = 0; columnIndex < preContingencyStates.getColumnCount(); ++columnIndex) {
            this.setAlphas(preContingencyStates, columnIndex);
            for (int rowIndex = 0; rowIndex < preContingencyStates.getRowCount(); ++rowIndex) {
                double postContingencyValue = preContingencyStates.get(rowIndex, columnIndex);
                for (ComputedContingencyElement contingencyElement : this.contingencyElements) {
                    postContingencyValue += contingencyElement.getAlphaForWoodburyComputation() * this.contingenciesStates.get(rowIndex, contingencyElement.getComputedElementIndex());
                }
                preContingencyStates.set(rowIndex, columnIndex, postContingencyValue);
            }
        }
    }

    public void toPostContingencyAndOperatorStrategyStates(double[] preContingencyStates) {
        Objects.requireNonNull(preContingencyStates);
        this.setAlphas(new DenseMatrix(preContingencyStates.length, 1, preContingencyStates), 0);
        for (int rowIndex = 0; rowIndex < preContingencyStates.length; ++rowIndex) {
            double postContingencyAndOperatorStrategyValue = preContingencyStates[rowIndex];
            for (ComputedContingencyElement contingencyElement : this.contingencyElements) {
                postContingencyAndOperatorStrategyValue += contingencyElement.getAlphaForWoodburyComputation() * this.contingenciesStates.get(rowIndex, contingencyElement.getComputedElementIndex());
            }
            for (AbstractComputedElement actionElement : this.actionElements) {
                postContingencyAndOperatorStrategyValue += actionElement.getAlphaForWoodburyComputation() * this.actionsStates.get(rowIndex, actionElement.getComputedElementIndex());
            }
            preContingencyStates[rowIndex] = postContingencyAndOperatorStrategyValue;
        }
    }
}

