/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationSystemIndexListener;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.Vector;
import com.powsybl.openloadflow.equations.Vectors;
import java.util.Objects;

public abstract class AbstractVector<V extends Enum<V>, E extends Enum<E>>
implements Vector {
    protected final EquationSystem<V, E> equationSystem;
    private double[] array;
    private Status status = Status.VECTOR_INVALID;
    private final EquationSystemIndexListener<V, E> equationSystemIndexListener = new EquationSystemIndexListener<V, E>(){

        @Override
        public void onEquationChange(Equation<V, E> equation, EquationSystemIndexListener.ChangeType changeType) {
            AbstractVector.this.invalidateVector();
        }

        @Override
        public void onVariableChange(Variable<V> variable, EquationSystemIndexListener.ChangeType changeType) {
        }

        @Override
        public void onEquationTermChange(EquationTerm<V, E> term) {
        }
    };

    protected AbstractVector(EquationSystem<V, E> equationSystem) {
        this.equationSystem = Objects.requireNonNull(equationSystem);
        equationSystem.getIndex().addListener(this.equationSystemIndexListener);
    }

    protected void invalidateValues() {
        if (this.status == Status.VALID) {
            this.status = Status.VALUES_INVALID;
        }
    }

    protected void invalidateVector() {
        this.status = Status.VECTOR_INVALID;
    }

    protected void validate() {
        this.status = Status.VALID;
    }

    @Override
    public double[] getArray() {
        switch (this.status) {
            case VECTOR_INVALID: {
                this.array = this.createArray();
                this.validate();
                break;
            }
            case VALUES_INVALID: {
                this.updateArray(this.array);
                this.validate();
                break;
            }
        }
        return this.array;
    }

    protected abstract double[] createArray();

    protected abstract void updateArray(double[] var1);

    @Override
    public void minus(Vector other) {
        Objects.requireNonNull(other);
        Vectors.minus(this.getArray(), other.getArray());
    }

    private static enum Status {
        VALID,
        VECTOR_INVALID,
        VALUES_INVALID;

    }
}

