/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.equations.EquationEventType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.EquationTermEventType;
import com.powsybl.openloadflow.equations.Quantity;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.util.Evaluable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Equation<V extends Enum<V>, E extends Enum<E>>
implements Evaluable,
Comparable<Equation<V, E>> {
    private final int elementNum;
    private final E type;
    private EquationSystem<V, E> equationSystem;
    private int column = -1;
    private boolean active = true;
    private final List<EquationTerm<V, E>> terms = new ArrayList<EquationTerm<V, E>>();
    private final Map<Variable<V>, List<EquationTerm<V, E>>> termsByVariable = new TreeMap<Variable<V>, List<EquationTerm<V, E>>>();
    private int[] matrixElementIndexes;

    Equation(int elementNum, E type, EquationSystem<V, E> equationSystem) {
        this.elementNum = elementNum;
        this.type = (Enum)Objects.requireNonNull(type);
        this.equationSystem = Objects.requireNonNull(equationSystem);
    }

    public int getElementNum() {
        return this.elementNum;
    }

    public E getType() {
        return this.type;
    }

    public EquationSystem<V, E> getEquationSystem() {
        this.checkNotRemoved();
        return this.equationSystem;
    }

    public void setRemoved() {
        this.equationSystem = null;
        this.column = -1;
    }

    private void checkNotRemoved() {
        if (this.equationSystem == null) {
            throw new PowsyblException(this + " has been removed from its equation system");
        }
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public boolean isActive() {
        return this.active;
    }

    public Equation<V, E> setActive(boolean active) {
        this.checkNotRemoved();
        if (active != this.active) {
            this.active = active;
            this.equationSystem.notifyEquationChange(this, active ? EquationEventType.EQUATION_ACTIVATED : EquationEventType.EQUATION_DEACTIVATED);
        }
        return this;
    }

    public Equation<V, E> addTerm(EquationTerm<V, E> term) {
        Objects.requireNonNull(term);
        this.checkNotRemoved();
        if (term.getEquation() != null) {
            throw new PowsyblException("Equation term already added to another equation: " + term.getEquation());
        }
        this.terms.add(term);
        for (Variable<V> v : term.getVariables()) {
            this.termsByVariable.computeIfAbsent(v, k -> new ArrayList()).add(term);
        }
        this.matrixElementIndexes = null;
        term.setEquation(this);
        this.equationSystem.addEquationTerm(term);
        this.equationSystem.notifyEquationTermChange(term, EquationTermEventType.EQUATION_TERM_ADDED);
        return this;
    }

    public Equation<V, E> addTerms(List<EquationTerm<V, E>> terms) {
        Objects.requireNonNull(terms);
        for (EquationTerm<V, E> term : terms) {
            this.addTerm(term);
        }
        return this;
    }

    public List<EquationTerm<V, E>> getTerms() {
        return this.terms;
    }

    public List<EquationTerm<V, E>> getLeafTerms() {
        ArrayList<EquationTerm<V, E>> leafTerms = new ArrayList<EquationTerm<V, E>>();
        for (EquationTerm<V, E> term : this.terms) {
            this.addLeafTerms(term, leafTerms);
        }
        return leafTerms;
    }

    private void addLeafTerms(EquationTerm<V, E> term, List<EquationTerm<V, E>> leafTerms) {
        List<EquationTerm<V, E>> children = term.getChildren();
        if (children.isEmpty()) {
            leafTerms.add(term);
        } else {
            for (EquationTerm<V, E> child : children) {
                this.addLeafTerms(child, leafTerms);
            }
        }
    }

    public Map<Variable<V>, List<EquationTerm<V, E>>> getTermsByVariable() {
        return this.termsByVariable;
    }

    @Override
    public double eval() {
        double value = 0.0;
        for (EquationTerm<V, E> term : this.terms) {
            if (!term.isActive()) continue;
            value += term.eval();
        }
        return value;
    }

    public double evalLhs() {
        double value = 0.0;
        for (EquationTerm<V, E> term : this.terms) {
            if (!term.isActive()) continue;
            value += term.evalLhs();
        }
        return value;
    }

    public void der(DerHandler<V> handler) {
        Objects.requireNonNull(handler);
        int variableIndex = 0;
        for (Map.Entry<Variable<V>, List<EquationTerm<V, E>>> e : this.termsByVariable.entrySet()) {
            Variable<V> variable = e.getKey();
            int row = variable.getRow();
            if (row == -1) continue;
            double value = 0.0;
            for (EquationTerm<V, E> term : e.getValue()) {
                if (!term.isActive()) continue;
                value += term.der(variable);
            }
            int oldMatrixElementIndex = this.matrixElementIndexes == null ? -1 : this.matrixElementIndexes[variableIndex];
            int matrixElementIndex = handler.onDer(variable, value, oldMatrixElementIndex);
            if (this.matrixElementIndexes == null) {
                this.matrixElementIndexes = new int[this.termsByVariable.size()];
            }
            this.matrixElementIndexes[variableIndex] = matrixElementIndex;
            ++variableIndex;
        }
    }

    public double rhs() {
        double rhs = 0.0;
        for (EquationTerm<V, E> term : this.terms) {
            if (!term.isActive() || !term.hasRhs()) continue;
            rhs += term.rhs();
        }
        return rhs;
    }

    public int hashCode() {
        return this.elementNum + ((Enum)this.type).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Equation) {
            Equation equation = (Equation)obj;
            return this.compareTo(equation) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Equation<V, E> o) {
        if (o == this) {
            return 0;
        }
        int c = this.elementNum - o.elementNum;
        if (c == 0) {
            c = ((Enum)this.type).ordinal() - ((Enum)o.type).ordinal();
        }
        return c;
    }

    public void write(Writer writer, boolean writeInactiveTerms) throws IOException {
        writer.append(((Quantity)this.type).getSymbol()).append(Integer.toString(this.elementNum)).append(" = ");
        List<EquationTerm<V, E>> activeTerms = writeInactiveTerms ? this.terms : this.terms.stream().filter(EquationTerm::isActive).collect(Collectors.toList());
        Iterator<EquationTerm<V, E>> it = activeTerms.iterator();
        while (it.hasNext()) {
            EquationTerm<V, E> term = it.next();
            if (!term.isActive()) {
                writer.write("[ ");
            }
            term.write(writer);
            if (!term.isActive()) {
                writer.write(" ]");
            }
            if (!it.hasNext()) continue;
            writer.append(" + ");
        }
    }

    public Optional<LfElement> getElement(LfNetwork network) {
        Objects.requireNonNull(network);
        LfElement element = null;
        switch (((Quantity)this.type).getElementType()) {
            case BUS: {
                element = network.getBus(this.elementNum);
                break;
            }
            case BRANCH: {
                element = network.getBranch(this.elementNum);
                break;
            }
            case SHUNT_COMPENSATOR: {
                element = network.getShunt(this.elementNum);
            }
        }
        return Optional.ofNullable(element);
    }

    public String toString() {
        return "Equation(elementNum=" + this.elementNum + ", type=" + this.type + ", column=" + this.column + ")";
    }

    public static interface DerHandler<V extends Enum<V>> {
        public int onDer(Variable<V> var1, double var2, int var4);
    }
}

