/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.util.Derivable;
import java.util.Objects;
import java.util.stream.Stream;

public class InjectionDerivable<V extends Enum<V>>
implements Derivable<V> {
    private final Equation<V, ?> equation;

    public InjectionDerivable(Equation<V, ?> equation) {
        Objects.requireNonNull(equation);
        this.equation = equation;
    }

    private Stream<? extends EquationTerm<V, ?>> getBranchTermStream() {
        return this.equation.getTerms().stream().filter(EquationTerm::isActive).filter(t -> t.getElementType() == ElementType.BRANCH);
    }

    @Override
    public double der(Variable<V> variable) {
        return -this.getBranchTermStream().mapToDouble(t -> t.der(variable)).sum();
    }

    @Override
    public double calculateSensi(DenseMatrix x, int column) {
        return -this.getBranchTermStream().mapToDouble(t -> t.calculateSensi(x, column)).sum();
    }

    @Override
    public double eval() {
        return -this.getBranchTermStream().mapToDouble(EquationTerm::eval).sum();
    }

    @Override
    public boolean isActive() {
        return this.getBranchTermStream().anyMatch(EquationTerm::isActive);
    }
}

