/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.openloadflow.equations.StateVectorListener;
import com.powsybl.openloadflow.equations.Vectors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StateVector {
    private double[] array;
    private final List<StateVectorListener> listeners = new ArrayList<StateVectorListener>();

    public StateVector() {
        this(null);
    }

    public StateVector(double[] array) {
        this.array = array;
    }

    public void set(double[] array) {
        this.array = Objects.requireNonNull(array);
        this.notifyStateUpdate();
    }

    public double[] get() {
        return this.array;
    }

    public double get(int variableNum) {
        return this.array[variableNum];
    }

    public void set(int variableNum, double value) {
        this.array[variableNum] = value;
        this.notifyStateUpdate();
    }

    public void minus(double[] b) {
        Vectors.minus(this.array, b);
        this.notifyStateUpdate();
    }

    private void notifyStateUpdate() {
        for (StateVectorListener listener : this.listeners) {
            listener.onStateUpdate();
        }
    }

    public void addListener(StateVectorListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(StateVectorListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }
}

