/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.equations.AbstractEquationTerm;
import com.powsybl.openloadflow.equations.Quantity;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.ElementType;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;

public class VariableEquationTerm<V extends Enum<V>, E extends Enum<E>>
extends AbstractEquationTerm<V, E> {
    private final List<Variable<V>> variables;

    public VariableEquationTerm(Variable<V> variable) {
        this.variables = List.of(Objects.requireNonNull(variable));
    }

    private Variable<V> getVariable() {
        return this.variables.get(0);
    }

    @Override
    public ElementType getElementType() {
        return ((Quantity)this.getVariable().getType()).getElementType();
    }

    @Override
    public int getElementNum() {
        return this.getVariable().getElementNum();
    }

    @Override
    public List<Variable<V>> getVariables() {
        return this.variables;
    }

    @Override
    public double eval() {
        return this.sv.get(this.getVariable().getRow());
    }

    @Override
    public double der(Variable<V> variable) {
        return 1.0;
    }

    @Override
    public double calculateSensi(DenseMatrix dx, int column) {
        return dx.get(this.getVariable().getRow(), column);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.getVariable().write(writer);
    }
}

