/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.graph.EdgeAdd;
import com.powsybl.openloadflow.graph.EdgeRemove;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.graph.GraphModification;
import com.powsybl.openloadflow.graph.ModificationsContext;
import com.powsybl.openloadflow.graph.VertexAdd;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.Pseudograph;

public abstract class AbstractGraphConnectivity<V, E>
implements GraphConnectivity<V, E> {
    private final Graph<V, E> graph = new Pseudograph(null, null, false);
    private final Deque<ModificationsContext<V, E>> modificationsContexts = new ArrayDeque<ModificationsContext<V, E>>();
    protected List<Set<V>> componentSets;
    private V defaultMainComponentVertex;

    protected abstract void updateConnectivity(EdgeRemove<V, E> var1);

    protected abstract void updateConnectivity(EdgeAdd<V, E> var1);

    protected abstract void updateConnectivity(VertexAdd<V, E> var1);

    protected abstract void resetConnectivity(Deque<GraphModification<V, E>> var1);

    protected abstract void updateComponents();

    @Override
    public void addVertex(V vertex) {
        Objects.requireNonNull(vertex);
        if (this.graph.containsVertex(vertex)) {
            return;
        }
        VertexAdd<V, E> vertexAdd = new VertexAdd<V, E>(vertex);
        vertexAdd.apply(this.graph);
        if (!this.modificationsContexts.isEmpty()) {
            ModificationsContext modificationsContext = this.modificationsContexts.peekLast();
            modificationsContext.add(vertexAdd);
            this.updateConnectivity(vertexAdd);
        }
    }

    @Override
    public void addEdge(V vertex1, V vertex2, E edge) {
        Objects.requireNonNull(vertex1);
        Objects.requireNonNull(vertex2);
        Objects.requireNonNull(edge);
        if (this.graph.containsEdge(edge)) {
            return;
        }
        EdgeAdd<V, E> edgeAdd = new EdgeAdd<V, E>(vertex1, vertex2, edge);
        edgeAdd.apply(this.graph);
        if (!this.modificationsContexts.isEmpty()) {
            ModificationsContext<V, E> modificationsContext = this.modificationsContexts.peekLast();
            modificationsContext.add(edgeAdd);
            this.updateConnectivity(edgeAdd);
        }
    }

    @Override
    public void removeEdge(E edge) {
        Objects.requireNonNull(edge);
        if (!this.graph.containsEdge(edge)) {
            return;
        }
        Object vertex1 = this.graph.getEdgeSource(edge);
        Object vertex2 = this.graph.getEdgeTarget(edge);
        EdgeRemove<Object, E> edgeRemove = new EdgeRemove<Object, E>(vertex1, vertex2, edge);
        edgeRemove.apply(this.graph);
        if (!this.modificationsContexts.isEmpty()) {
            ModificationsContext<Object, E> modificationsContext = this.modificationsContexts.peekLast();
            modificationsContext.add(edgeRemove);
            this.updateConnectivity(edgeRemove);
        }
    }

    @Override
    public void startTemporaryChanges() {
        ModificationsContext modificationsContext = new ModificationsContext(this::getVerticesNotInMainComponent, this.defaultMainComponentVertex);
        this.modificationsContexts.add(modificationsContext);
        modificationsContext.computeVerticesNotInMainComponentBefore();
    }

    @Override
    public void undoTemporaryChanges() {
        if (this.modificationsContexts.isEmpty()) {
            throw new PowsyblException("Cannot reset, no remaining saved connectivity");
        }
        ModificationsContext<V, E> m = this.modificationsContexts.pollLast();
        Deque<GraphModification<V, E>> modifications = m.getModifications();
        this.resetConnectivity(modifications);
        modifications.descendingIterator().forEachRemaining(gm -> gm.undo(this.graph));
    }

    @Override
    public int getComponentNumber(V vertex) {
        this.checkSavedContext();
        this.checkVertex(vertex);
        this.updateComponents();
        return this.getQuickComponentNumber(vertex);
    }

    protected abstract int getQuickComponentNumber(V var1);

    @Override
    public int getNbConnectedComponents() {
        this.checkSavedContext();
        this.updateComponents();
        return this.componentSets.size();
    }

    protected Collection<Set<V>> getSmallComponents() {
        this.checkSavedContext();
        this.updateComponents();
        return this.componentSets.subList(1, this.componentSets.size());
    }

    @Override
    public Set<V> getConnectedComponent(V vertex) {
        int componentNumber = this.getComponentNumber(vertex);
        return this.componentSets.get(componentNumber);
    }

    @Override
    public Set<V> getLargestConnectedComponent() {
        this.checkSavedContext();
        this.updateComponents();
        return this.componentSets.get(0);
    }

    protected Set<V> getNonConnectedVertices(V vertex) {
        Set connectedComponent = this.getConnectedComponent(vertex);
        return this.componentSets.stream().filter(component -> component != connectedComponent).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    protected Deque<ModificationsContext<V, E>> getModificationsContexts() {
        return this.modificationsContexts;
    }

    protected ModificationsContext<V, E> checkSavedContext() {
        if (this.modificationsContexts.isEmpty()) {
            throw new PowsyblException("Cannot compute connectivity without a saved state, please call GraphConnectivity::startTemporaryChanges at least once beforehand");
        }
        return this.modificationsContexts.peekLast();
    }

    protected void checkVertex(V vertex) {
        if (!this.graph.containsVertex(vertex)) {
            throw new IllegalArgumentException("given vertex " + vertex + " is not in the graph");
        }
    }

    @Override
    public Set<V> getVerticesAddedToMainComponent() {
        return this.checkSavedContext().getVerticesAddedToMainComponent();
    }

    @Override
    public Set<E> getEdgesAddedToMainComponent() {
        return this.checkSavedContext().getEdgesAddedToMainComponent(this.graph);
    }

    @Override
    public Set<V> getVerticesRemovedFromMainComponent() {
        return this.checkSavedContext().getVerticesRemovedFromMainComponent();
    }

    @Override
    public Set<E> getEdgesRemovedFromMainComponent() {
        return this.checkSavedContext().getEdgesRemovedFromMainComponent(this.graph);
    }

    private Set<V> getVerticesNotInMainComponent(V mainComponentVertex) {
        if (mainComponentVertex != null) {
            return this.getNonConnectedVertices(mainComponentVertex);
        }
        return this.getSmallComponents().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void setMainComponentVertex(V mainComponentVertex) {
        if (!this.modificationsContexts.isEmpty()) {
            ModificationsContext<V, E> modificationsContext = this.modificationsContexts.peekLast();
            modificationsContext.setMainComponentVertex(mainComponentVertex);
            if (!modificationsContext.isInMainComponentBefore(mainComponentVertex)) {
                throw new PowsyblException("Cannot take the given vertex as main component vertex! This vertex was outside the main component before starting temporary changes");
            }
        }
        this.defaultMainComponentVertex = mainComponentVertex;
    }
}

