/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.jgrapht.Graph;
import org.jgrapht.graph.Pseudograph;

class BridgesFinder<V> {
    private final int nbVertices;
    private final ToIntFunction<V> numGetter;
    private final Graph<Integer, Object> graph = new Pseudograph(Object.class);
    private List<int[]> bridges;
    private final NeighbourList[] neighbours;
    private final boolean[] visited;
    private final int[] dfsn;
    private int dfsnCount;

    BridgesFinder(int nbVertices, ToIntFunction<V> numGetter) {
        this.numGetter = Objects.requireNonNull(numGetter);
        this.nbVertices = nbVertices;
        this.visited = new boolean[nbVertices];
        this.dfsn = new int[nbVertices];
        this.neighbours = new NeighbourList[nbVertices];
        for (int i = 0; i < nbVertices; ++i) {
            this.neighbours[i] = new NeighbourList();
        }
        this.dfsnCount = 0;
    }

    private int findBridgesFromVertex(int start, int parent) {
        this.visited[start] = true;
        this.dfsn[start] = ++this.dfsnCount;
        int lowestReachableVertex = this.dfsnCount;
        Iterator iterator = this.neighbours[start].iterator();
        while (iterator.hasNext()) {
            int neighbour = (Integer)iterator.next();
            if (!this.visited[neighbour]) {
                int lowestN = this.findBridgesFromVertex(neighbour, start);
                if (lowestReachableVertex > lowestN) {
                    lowestReachableVertex = lowestN;
                }
                if (lowestN <= this.dfsn[start] || this.doubledEdge(start, neighbour)) continue;
                this.bridges.add(new int[]{start, neighbour});
                continue;
            }
            if (neighbour == parent || lowestReachableVertex <= this.dfsn[neighbour]) continue;
            lowestReachableVertex = this.dfsn[neighbour];
        }
        return lowestReachableVertex;
    }

    private boolean doubledEdge(int u, int v) {
        return this.graph.getAllEdges((Object)u, (Object)v).size() > 1;
    }

    List<int[]> getBridges() {
        this.lazySearch();
        return this.bridges;
    }

    private void lazySearch() {
        if (this.bridges == null) {
            this.dfsnCount = 0;
            this.bridges = new ArrayList<int[]>();
            Arrays.fill(this.visited, false);
            for (int i = 0; i < this.nbVertices; ++i) {
                if (this.visited[i]) continue;
                this.findBridgesFromVertex(i, i);
            }
        }
    }

    public void addVertex(V vertex) {
        Objects.requireNonNull(vertex);
        this.graph.addVertex((Object)this.numGetter.applyAsInt(vertex));
    }

    public void addEdge(V vertex1, V vertex2) {
        Objects.requireNonNull(vertex1);
        Objects.requireNonNull(vertex2);
        this.addEdge(this.numGetter.applyAsInt(vertex1), this.numGetter.applyAsInt(vertex2));
    }

    private void addEdge(int num1, int num2) {
        this.graph.addEdge((Object)num1, (Object)num2, new Object());
        this.neighbours[num1].add(num2);
        this.neighbours[num2].add(num1);
    }

    private static class NeighbourList
    extends ArrayList<Integer> {
        private NeighbourList() {
        }
    }
}

