/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import com.powsybl.openloadflow.graph.AbstractGraphConnectivity;
import com.powsybl.openloadflow.graph.EdgeAdd;
import com.powsybl.openloadflow.graph.EdgeRemove;
import com.powsybl.openloadflow.graph.GraphModification;
import com.powsybl.openloadflow.graph.VertexAdd;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.util.UnionFind;

public class MinimumSpanningTreeGraphConnectivity<V, E>
extends AbstractGraphConnectivity<V, E> {
    private final Deque<SpanningTrees> mstSaved = new ArrayDeque<SpanningTrees>();
    private SpanningTrees mst;

    @Override
    protected void updateConnectivity(EdgeAdd<V, E> edgeAdd) {
        if (this.mst != null) {
            this.mst.addEdge(edgeAdd.v1, edgeAdd.v2, edgeAdd.e);
        }
        this.componentSets = null;
    }

    @Override
    protected void updateConnectivity(VertexAdd<V, E> vertexAdd) {
        if (this.mst != null) {
            this.mst.addVertex(vertexAdd.v);
        }
        this.componentSets = null;
    }

    @Override
    protected void updateConnectivity(EdgeRemove<V, E> edgeRemove) {
        if (this.mst == null || this.mst.getEdges().contains(edgeRemove.e)) {
            this.mst = null;
            this.componentSets = null;
        }
    }

    @Override
    public boolean supportTemporaryChangesNesting() {
        return true;
    }

    @Override
    public void startTemporaryChanges() {
        super.startTemporaryChanges();
        if (this.mst == null) {
            this.mst = new KruskalMinimumSpanningTrees().getSpanningTree();
        }
        this.mstSaved.add(this.mst);
        this.mst = new SpanningTrees(this.mst);
    }

    @Override
    protected void resetConnectivity(Deque<GraphModification<V, E>> m) {
        if (this.mstSaved.isEmpty()) {
            throw new IllegalArgumentException("Corrupted connectivity cache");
        }
        this.mst = this.mstSaved.pollLast();
        this.componentSets = null;
    }

    @Override
    protected int getQuickComponentNumber(V vertex) {
        Set cc = this.mst.forest.getConnectedComponent(vertex);
        return this.componentSets.indexOf(cc);
    }

    @Override
    protected void updateComponents() {
        if (this.mst == null) {
            this.mst = new KruskalMinimumSpanningTrees().getSpanningTree();
        }
        if (this.componentSets == null) {
            this.componentSets = this.mst.forest.getConnectedComponents();
        }
    }

    private class SpanningTrees
    extends SpanningTreeAlgorithm.SpanningTreeImpl<Object> {
        private final transient MyUnionFind forest;

        public SpanningTrees(MyUnionFind forest, Set<Object> edgeList, double spanningTreeCost) {
            super(edgeList, spanningTreeCost);
            this.forest = forest;
        }

        public SpanningTrees(SpanningTrees other) {
            super(new LinkedHashSet(other.getEdges()), other.getWeight());
            this.forest = new MyUnionFind(other.forest);
        }

        private void addEdge(V source, V target, E edge) {
            if (!this.forest.find(source).equals(this.forest.find(target))) {
                this.forest.union(source, target);
                this.getEdges().add(edge);
                this.forest.invalidateConnectedComponents();
            }
        }

        public void addVertex(V v) {
            this.forest.addElement(v);
        }
    }

    class KruskalMinimumSpanningTrees
    implements SpanningTreeAlgorithm<Object> {
        KruskalMinimumSpanningTrees() {
        }

        public SpanningTrees getSpanningTree() {
            Graph graph = MinimumSpanningTreeGraphConnectivity.this.getGraph();
            MyUnionFind forest = new MyUnionFind(graph.vertexSet());
            HashSet<Object> edgeList = new HashSet<Object>();
            SpanningTrees spanningTree = new SpanningTrees(forest, edgeList, 0.0);
            for (Object edge : graph.edgeSet()) {
                Object source = graph.getEdgeSource(edge);
                Object target = graph.getEdgeTarget(edge);
                spanningTree.addEdge(source, target, edge);
            }
            return spanningTree;
        }
    }

    private class MyUnionFind
    extends UnionFind<V> {
        private Map<V, Set<V>> rootConnectedComponentMap;

        public MyUnionFind(Set<V> vs) {
            super(vs);
        }

        public MyUnionFind(MyUnionFind other) {
            super(other.getParentMap().keySet());
            other.getRankMap().forEach((k, v) -> this.getRankMap().put(k, v));
            other.getParentMap().forEach((k, v) -> this.getParentMap().put(k, v));
            this.rootConnectedComponentMap = null;
        }

        public List<Set<V>> getConnectedComponents() {
            this.lazyComputeConnectedComponents();
            return this.rootConnectedComponentMap.values().stream().sorted((cc1, cc2) -> cc2.size() - cc1.size()).collect(Collectors.toList());
        }

        public Set<V> getConnectedComponent(V vertex) {
            this.lazyComputeConnectedComponents();
            Object root = super.getParentMap().get(vertex);
            return this.rootConnectedComponentMap.get(root);
        }

        private void lazyComputeConnectedComponents() {
            if (this.rootConnectedComponentMap == null) {
                this.rootConnectedComponentMap = new HashMap();
                MinimumSpanningTreeGraphConnectivity.this.getGraph().vertexSet().forEach(vertex -> this.rootConnectedComponentMap.computeIfAbsent((Set)this.find(vertex), (Function<Set, Set<Set>>)((Function<Object, Set>)k -> new HashSet())).add(vertex));
            }
        }

        public void addElement(V v) {
            super.addElement(v);
            HashSet connectedComponent = new HashSet();
            connectedComponent.add(v);
            this.rootConnectedComponentMap.put(this.find(v), connectedComponent);
        }

        public void invalidateConnectedComponents() {
            this.rootConnectedComponentMap = null;
        }
    }
}

