/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import com.powsybl.openloadflow.graph.AbstractGraphConnectivity;
import com.powsybl.openloadflow.graph.EdgeAdd;
import com.powsybl.openloadflow.graph.EdgeRemove;
import com.powsybl.openloadflow.graph.GraphModification;
import com.powsybl.openloadflow.graph.VertexAdd;
import java.util.Comparator;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.jgrapht.alg.connectivity.ConnectivityInspector;

public class NaiveGraphConnectivity<V, E>
extends AbstractGraphConnectivity<V, E> {
    private int[] components;
    private final ToIntFunction<V> numGetter;

    public NaiveGraphConnectivity(ToIntFunction<V> numGetter) {
        this.numGetter = Objects.requireNonNull(numGetter);
    }

    @Override
    public boolean supportTemporaryChangesNesting() {
        return true;
    }

    @Override
    protected void updateComponents() {
        if (this.components == null) {
            this.components = new int[this.getGraph().vertexSet().size()];
            this.componentSets = new ConnectivityInspector(this.getGraph()).connectedSets().stream().sorted(Comparator.comparing(Set::size).reversed()).collect(Collectors.toList());
            for (int componentIndex = 0; componentIndex < this.componentSets.size(); ++componentIndex) {
                Set vertices = (Set)this.componentSets.get(componentIndex);
                for (Object vertex : vertices) {
                    this.components[this.numGetter.applyAsInt(vertex)] = componentIndex;
                }
            }
        }
    }

    @Override
    protected void resetConnectivity(Deque<GraphModification<V, E>> m) {
        this.invalidateComponents();
    }

    @Override
    protected int getQuickComponentNumber(V vertex) {
        return this.components[this.numGetter.applyAsInt(vertex)];
    }

    @Override
    protected void updateConnectivity(EdgeRemove<V, E> edgeRemove) {
        this.invalidateComponents();
    }

    @Override
    protected void updateConnectivity(EdgeAdd<V, E> edgeAdd) {
        this.invalidateComponents();
    }

    @Override
    protected void updateConnectivity(VertexAdd<V, E> vertexAdd) {
        this.invalidateComponents();
    }

    private void invalidateComponents() {
        this.components = null;
    }
}

