/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.network.AbstractLfNetworkListener;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LoadFlowModel;
import java.util.Objects;

public abstract class AbstractEquationSystemUpdater<V extends Enum<V>, E extends Enum<E>>
extends AbstractLfNetworkListener {
    protected final EquationSystem<V, E> equationSystem;
    protected final LoadFlowModel loadFlowModel;

    protected AbstractEquationSystemUpdater(EquationSystem<V, E> equationSystem, LoadFlowModel loadFlowModel) {
        this.equationSystem = Objects.requireNonNull(equationSystem);
        this.loadFlowModel = Objects.requireNonNull(loadFlowModel);
    }

    protected static void checkSlackBus(LfBus bus, boolean disabled) {
        if (disabled && bus.isSlack()) {
            throw new PowsyblException("Slack bus '" + bus.getId() + "' disabling is not supported");
        }
    }

    protected abstract void updateNonImpedantBranchEquations(LfBranch var1, boolean var2);

    @Override
    public void onZeroImpedanceNetworkSpanningTreeChange(LfBranch branch, LoadFlowModel loadFlowModel, boolean spanningTree) {
        if (loadFlowModel == this.loadFlowModel) {
            this.updateNonImpedantBranchEquations(branch, !branch.isDisabled() && spanningTree);
        }
    }

    protected void updateElementEquations(LfElement element, boolean enable) {
        LfBranch branch;
        if (element instanceof LfBranch && (branch = (LfBranch)element).isZeroImpedance(this.loadFlowModel)) {
            this.updateNonImpedantBranchEquations(branch, enable && branch.isSpanningTreeEdge(this.loadFlowModel));
        } else {
            for (Equation<V, E> equation : this.equationSystem.getEquations(element.getType(), element.getNum())) {
                if (equation.isActive() == enable) continue;
                equation.setActive(enable);
            }
            for (EquationTerm equationTerm : this.equationSystem.getEquationTerms(element.getType(), element.getNum())) {
                if (equationTerm.isActive() == enable) continue;
                equationTerm.setActive(enable);
            }
        }
    }

    protected abstract E getTypeBusTargetP();

    protected abstract E getTypeBusTargetPhi();

    protected abstract V getTypeBusPhi();

    @Override
    public void onSlackBusChange(LfBus bus, boolean slack) {
        this.equationSystem.getEquation(bus.getNum(), this.getTypeBusTargetP()).orElseThrow().setActive(!slack);
    }

    @Override
    public void onReferenceBusChange(LfBus bus, boolean reference) {
        if (reference) {
            Equation<V, E> phiEq = this.equationSystem.getEquation(bus.getNum(), this.getTypeBusTargetPhi()).orElse(null);
            if (phiEq == null) {
                phiEq = this.equationSystem.createEquation(bus, this.getTypeBusTargetPhi()).addTerm(this.equationSystem.getVariable(bus.getNum(), this.getTypeBusPhi()).createTerm());
            }
            phiEq.setActive(true);
        } else {
            this.equationSystem.getEquation(bus.getNum(), this.getTypeBusTargetPhi()).orElseThrow().setActive(false);
        }
    }
}

