/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf;

import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseMatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import java.util.Objects;

public abstract class AbstractLoadFlowParameters<P extends AbstractLoadFlowParameters<P>> {
    public static final int DEFAULT_MAX_OUTER_LOOP_ITERATIONS = 20;
    protected LfNetworkParameters networkParameters;
    protected MatrixFactory matrixFactory;
    protected OpenLoadFlowParameters.SlackDistributionFailureBehavior slackDistributionFailureBehavior = OpenLoadFlowParameters.SlackDistributionFailureBehavior.LEAVE_ON_SLACK_BUS;

    protected AbstractLoadFlowParameters() {
        this(new LfNetworkParameters(), (MatrixFactory)new SparseMatrixFactory());
    }

    protected AbstractLoadFlowParameters(LfNetworkParameters networkParameters, MatrixFactory matrixFactory) {
        this.networkParameters = Objects.requireNonNull(networkParameters);
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
    }

    public LfNetworkParameters getNetworkParameters() {
        return this.networkParameters;
    }

    public P setNetworkParameters(LfNetworkParameters networkParameters) {
        this.networkParameters = Objects.requireNonNull(networkParameters);
        return (P)this;
    }

    public MatrixFactory getMatrixFactory() {
        return this.matrixFactory;
    }

    public P setMatrixFactory(MatrixFactory matrixFactory) {
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        return (P)this;
    }

    public OpenLoadFlowParameters.SlackDistributionFailureBehavior getSlackDistributionFailureBehavior() {
        return this.slackDistributionFailureBehavior;
    }

    public P setSlackDistributionFailureBehavior(OpenLoadFlowParameters.SlackDistributionFailureBehavior slackDistributionFailureBehavior) {
        this.slackDistributionFailureBehavior = Objects.requireNonNull(slackDistributionFailureBehavior);
        return (P)this;
    }
}

