/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.lf.outerloop.AbstractActivePowerDistributionOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.AbstractOuterLoopContext;
import com.powsybl.openloadflow.lf.outerloop.AreaInterchangeControlContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfArea;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.util.Reports;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public abstract class AbstractAreaInterchangeControlOuterLoop<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters<P>, C extends LoadFlowContext<V, E, P>, O extends AbstractOuterLoopContext<V, E, P, C>>
extends AbstractActivePowerDistributionOuterLoop<V, E, P, C, O> {
    public static final String NAME = "AreaInterchangeControl";
    private final Logger logger;
    protected static final String FAILED_TO_DISTRIBUTE_INTERCHANGE_ACTIVE_POWER_MISMATCH = "Failed to distribute interchange active power mismatch";
    protected static final String DEFAULT_NO_AREA_NAME = "BUSES_WITH_NO_AREA";
    protected final double slackBusPMaxMismatch;
    protected final double areaInterchangePMaxMismatch;
    protected final ActivePowerDistribution activePowerDistribution;
    protected final OuterLoop<V, E, P, C, O> noAreaOuterLoop;

    protected AbstractAreaInterchangeControlOuterLoop(ActivePowerDistribution activePowerDistribution, OuterLoop<V, E, P, C, O> noAreaOuterLoop, double slackBusPMaxMismatch, double areaInterchangePMaxMismatch, Logger logger) {
        this.activePowerDistribution = Objects.requireNonNull(activePowerDistribution);
        this.slackBusPMaxMismatch = slackBusPMaxMismatch;
        this.areaInterchangePMaxMismatch = areaInterchangePMaxMismatch;
        this.logger = logger;
        this.noAreaOuterLoop = noAreaOuterLoop;
    }

    @Override
    public void initialize(O context) {
        LfNetwork network = ((AbstractOuterLoopContext)context).getNetwork();
        if (!network.hasArea() && this.noAreaOuterLoop != null) {
            this.noAreaOuterLoop.initialize(context);
            return;
        }
        AreaInterchangeControlContextData contextData = new AreaInterchangeControlContextData(this.listBusesWithoutArea(network), this.allocateSlackDistributionParticipationFactors(network));
        ((AbstractOuterLoopContext)context).setData(contextData);
    }

    @Override
    public OuterLoopResult check(O context, ReportNode reportNode) {
        LfNetwork network = ((AbstractOuterLoopContext)context).getNetwork();
        if (!network.hasArea() && this.noAreaOuterLoop != null) {
            return this.noAreaOuterLoop.check(context, reportNode);
        }
        double slackBusActivePowerMismatch = this.getSlackBusActivePowerMismatch(context);
        AreaInterchangeControlContextData contextData = (AreaInterchangeControlContextData)((AbstractOuterLoopContext)context).getData();
        Map<String, Double> areaSlackDistributionParticipationFactor = contextData.getAreaSlackDistributionParticipationFactor();
        Map<LfArea, Double> areaInterchangeWithSlackMismatches = network.getAreaStream().collect(Collectors.toMap(area -> area, area -> this.getInterchangeMismatchWithSlack((LfArea)area, slackBusActivePowerMismatch, areaSlackDistributionParticipationFactor)));
        List<LfArea> areasToBalance = areaInterchangeWithSlackMismatches.entrySet().stream().filter(entry -> {
            double areaActivePowerMismatch = (Double)entry.getValue();
            return !this.lessThanInterchangeMaxMismatch(areaActivePowerMismatch);
        }).map(Map.Entry::getKey).toList();
        if (areasToBalance.isEmpty()) {
            Map<String, Double> areaInterchangeMismatches = network.getAreaStream().filter(area -> {
                double areaInterchangeMismatch = this.getInterchangeMismatch((LfArea)area);
                return !this.lessThanInterchangeMaxMismatch(areaInterchangeMismatch);
            }).collect(Collectors.toMap(LfArea::getId, this::getInterchangeMismatch));
            if (!areaInterchangeMismatches.isEmpty() || !this.lessThanSlackBusMaxMismatch(slackBusActivePowerMismatch)) {
                Set<LfBus> busesWithoutArea = contextData.getBusesWithoutArea();
                Map<String, Pair<Set<LfBus>, Double>> busesNoAreaDistributionMap = Map.of(DEFAULT_NO_AREA_NAME, Pair.of(busesWithoutArea, (Object)slackBusActivePowerMismatch));
                Map<String, ActivePowerDistribution.Result> busesNoAreaDistributionResult = this.distributeActivePower(busesNoAreaDistributionMap);
                double remainingSlackBusMismatch = busesNoAreaDistributionResult.get(DEFAULT_NO_AREA_NAME).remainingMismatch();
                if (this.lessThanSlackBusMaxMismatch(remainingSlackBusMismatch)) {
                    return this.buildOuterLoopResult(busesNoAreaDistributionMap, busesNoAreaDistributionResult, reportNode, context);
                }
                Map<String, Pair<Set<LfBus>, Double>> allBusesDistributionMap = Map.of("ALL_NETWORK", Pair.of(new HashSet<LfBus>(network.getBuses()), (Object)remainingSlackBusMismatch));
                Map<String, ActivePowerDistribution.Result> allBusesDistributionResult = this.distributeActivePower(allBusesDistributionMap);
                return this.buildOuterLoopResult(allBusesDistributionMap, allBusesDistributionResult, reportNode, context);
            }
            this.logger.debug("Already balanced");
            return new OuterLoopResult(this, OuterLoopStatus.STABLE);
        }
        Map<String, Pair<Set<LfBus>, Double>> areasDistributionMap = areasToBalance.stream().collect(Collectors.toMap(LfArea::getId, area -> Pair.of(area.getBuses(), (Object)this.getInterchangeMismatchWithSlack((LfArea)area, slackBusActivePowerMismatch, areaSlackDistributionParticipationFactor))));
        Map<String, ActivePowerDistribution.Result> areasDistributionResults = this.distributeActivePower(areasDistributionMap);
        return this.buildOuterLoopResult(areasDistributionMap, areasDistributionResults, reportNode, context);
    }

    protected Map<String, ActivePowerDistribution.Result> distributeActivePower(Map<String, Pair<Set<LfBus>, Double>> areas) {
        HashMap<String, ActivePowerDistribution.Result> resultByArea = new HashMap<String, ActivePowerDistribution.Result>();
        for (Map.Entry<String, Pair<Set<LfBus>, Double>> e : areas.entrySet()) {
            double areaActivePowerMismatch = (Double)e.getValue().getRight();
            ActivePowerDistribution.Result result = this.activePowerDistribution.run(null, (Collection)e.getValue().getLeft(), areaActivePowerMismatch);
            resultByArea.put(e.getKey(), result);
        }
        return resultByArea;
    }

    protected boolean lessThanInterchangeMaxMismatch(double mismatch) {
        return Math.abs(mismatch) <= this.areaInterchangePMaxMismatch / 100.0 || Math.abs(mismatch) <= ActivePowerDistribution.P_RESIDUE_EPS;
    }

    boolean lessThanSlackBusMaxMismatch(double mismatch) {
        return Math.abs(mismatch) <= this.slackBusPMaxMismatch / 100.0 || Math.abs(mismatch) <= ActivePowerDistribution.P_RESIDUE_EPS;
    }

    protected double getInterchangeMismatch(LfArea area) {
        return area.getInterchange() - area.getInterchangeTarget();
    }

    protected double getInterchangeMismatchWithSlack(LfArea area, double slackBusActivePowerMismatch, Map<String, Double> areaSlackDistributionParticipationFactor) {
        return area.getInterchange() - area.getInterchangeTarget() + this.getSlackInjection(area.getId(), slackBusActivePowerMismatch, areaSlackDistributionParticipationFactor);
    }

    protected double getSlackInjection(String areaId, double slackBusActivePowerMismatch, Map<String, Double> areaSlackDistributionParticipationFactor) {
        return areaSlackDistributionParticipationFactor.getOrDefault(areaId, 0.0) * slackBusActivePowerMismatch;
    }

    protected OuterLoopResult buildOuterLoopResult(Map<String, Pair<Set<LfBus>, Double>> areas, Map<String, ActivePowerDistribution.Result> resultByArea, ReportNode reportNode, O context) {
        HashMap<String, Double> remainingMismatchByArea = new HashMap<String, Double>();
        HashMap<String, Integer> iterationsByArea = new HashMap<String, Integer>();
        double totalDistributedActivePower = 0.0;
        boolean movedBuses = false;
        for (Map.Entry<String, ActivePowerDistribution.Result> e : resultByArea.entrySet()) {
            String area = e.getKey();
            ActivePowerDistribution.Result result = e.getValue();
            if (!this.lessThanInterchangeMaxMismatch(result.remainingMismatch())) {
                remainingMismatchByArea.put(area, result.remainingMismatch());
            }
            totalDistributedActivePower += (Double)areas.get(area).getRight() - result.remainingMismatch();
            movedBuses |= result.movedBuses();
            iterationsByArea.put(area, result.iteration());
        }
        ReportNode iterationReportNode = Reports.createOuterLoopIterationReporter(reportNode, ((AbstractOuterLoopContext)context).getOuterLoopTotalIterations() + 1);
        AreaInterchangeControlContextData contextData = (AreaInterchangeControlContextData)((AbstractOuterLoopContext)context).getData();
        contextData.addDistributedActivePower(totalDistributedActivePower);
        if (!remainingMismatchByArea.isEmpty()) {
            this.logger.error(FAILED_TO_DISTRIBUTE_INTERCHANGE_ACTIVE_POWER_MISMATCH);
            ReportNode failureReportNode = Reports.reportAreaInterchangeControlDistributionFailure(iterationReportNode);
            remainingMismatchByArea.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                this.logger.error("Remaining mismatch for Area {}: {} MW", entry.getKey(), (Object)((Double)entry.getValue() * 100.0));
                Reports.reportAreaInterchangeControlAreaMismatch(failureReportNode, (String)entry.getKey(), (Double)entry.getValue() * 100.0);
            });
            switch (((AbstractLoadFlowParameters)((AbstractOuterLoopContext)context).getLoadFlowContext().getParameters()).getSlackDistributionFailureBehavior()) {
                case THROW: {
                    throw new PowsyblException(FAILED_TO_DISTRIBUTE_INTERCHANGE_ACTIVE_POWER_MISMATCH);
                }
                case LEAVE_ON_SLACK_BUS: {
                    return new OuterLoopResult(this, movedBuses ? OuterLoopStatus.UNSTABLE : OuterLoopStatus.STABLE);
                }
                case FAIL: 
                case DISTRIBUTE_ON_REFERENCE_GENERATOR: {
                    contextData.addDistributedActivePower(-totalDistributedActivePower);
                    return new OuterLoopResult(this, OuterLoopStatus.FAILED, FAILED_TO_DISTRIBUTE_INTERCHANGE_ACTIVE_POWER_MISMATCH);
                }
            }
            throw new IllegalStateException("Unexpected SlackDistributionFailureBehavior value");
        }
        if (movedBuses) {
            areas.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                this.logger.info("Area {} interchange mismatch ({} MW) distributed in {} distribution iteration(s)", new Object[]{entry.getKey(), (Double)((Pair)entry.getValue()).getValue() * 100.0, iterationsByArea.get(entry.getKey())});
                Reports.reportAreaInterchangeControlAreaDistributionSuccess(iterationReportNode, (String)entry.getKey(), (Double)((Pair)entry.getValue()).getValue() * 100.0, (Integer)iterationsByArea.get(entry.getKey()));
            });
            return new OuterLoopResult(this, OuterLoopStatus.UNSTABLE);
        }
        return new OuterLoopResult(this, OuterLoopStatus.STABLE);
    }

    protected Set<LfBus> listBusesWithoutArea(LfNetwork network) {
        return network.getBuses().stream().filter(b -> b.getArea().isEmpty()).filter(b -> !b.isFictitious()).collect(Collectors.toSet());
    }

    protected Map<String, Double> allocateSlackDistributionParticipationFactors(LfNetwork lfNetwork) {
        HashMap<String, Double> areaSlackDistributionParticipationFactor = new HashMap<String, Double>();
        List<LfBus> slackBuses = lfNetwork.getSlackBuses();
        int totalSlackBusCount = slackBuses.size();
        for (LfBus slackBus : slackBuses) {
            Optional<LfArea> areaOpt = slackBus.getArea();
            if (areaOpt.isPresent()) {
                areaSlackDistributionParticipationFactor.put(areaOpt.get().getId(), areaSlackDistributionParticipationFactor.getOrDefault(areaOpt.get().getId(), 0.0) + 1.0 / (double)totalSlackBusCount);
                continue;
            }
            HashSet<LfBranch> connectedBranches = new HashSet<LfBranch>(slackBus.getBranches());
            Set connectedAreas = connectedBranches.stream().flatMap(branch -> Stream.of(branch.getBus1(), branch.getBus2())).filter(Objects::nonNull).map(LfBus::getArea).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            Set<LfArea> areasSharingSlack = connectedAreas.stream().filter(area -> area.getBoundaries().stream().noneMatch(boundary -> connectedBranches.contains(boundary.getBranch()))).collect(Collectors.toSet());
            if (!areasSharingSlack.isEmpty()) {
                areasSharingSlack.forEach(area -> areaSlackDistributionParticipationFactor.put(area.getId(), areaSlackDistributionParticipationFactor.getOrDefault(area.getId(), 0.0) + 1.0 / (double)areasSharingSlack.size() / (double)totalSlackBusCount));
                this.logger.warn("Slack bus {} is not in any Area and is connected to Areas: {}. Areas {} are not considering the flow through this bus for their interchange flow. The slack will be distributed between those areas.", new Object[]{slackBus.getId(), connectedAreas.stream().map(LfArea::getId).toList(), areasSharingSlack.stream().map(LfArea::getId).toList()});
                continue;
            }
            areaSlackDistributionParticipationFactor.put(DEFAULT_NO_AREA_NAME, areaSlackDistributionParticipationFactor.getOrDefault(DEFAULT_NO_AREA_NAME, 0.0) + 1.0 / (double)totalSlackBusCount);
        }
        return areaSlackDistributionParticipationFactor;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

