/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.lf.outerloop.AbstractPhaseControlOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.IncrementalContextData;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopContext;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.util.Evaluable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public abstract class AbstractIncrementalPhaseControlOuterLoop<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters, C extends LoadFlowContext<V, E, P>, O extends OuterLoopContext<V, E, P, C>>
extends AbstractPhaseControlOuterLoop<V, E, P, C, O> {
    public static final int MAX_DIRECTION_CHANGE = 3;
    public static final int MAX_TAP_SHIFT = Integer.MAX_VALUE;
    public static final double MIN_TARGET_DEADBAND = 0.01;
    public static final double SENSI_EPS = 1.0E-6;
    public static final double PHASE_SHIFT_CROSS_IMPACT_MARGIN = 0.75;
    public static final String NAME = "IncrementalPhaseControl";
    protected final Logger logger;

    protected AbstractIncrementalPhaseControlOuterLoop(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public void initialize(O context) {
        IncrementalContextData contextData = new IncrementalContextData();
        context.setData(contextData);
        List<LfBranch> controllerBranches = AbstractIncrementalPhaseControlOuterLoop.getControllerBranches(context.getNetwork());
        for (LfBranch controllerBranch : controllerBranches) {
            contextData.getControllersContexts().put(controllerBranch.getId(), new IncrementalContextData.ControllerContext(3));
        }
        AbstractIncrementalPhaseControlOuterLoop.fixPhaseShifterNecessaryForConnectivity(context.getNetwork(), controllerBranches);
    }

    public static double getHalfTargetDeadband(TransformerPhaseControl phaseControl) {
        return Math.max(phaseControl.getTargetDeadband(), 0.01) / 2.0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected int checkActivePowerControlPhaseControls(AbstractSensitivityContext<V, E> sensitivityContext, IncrementalContextData contextData, List<TransformerPhaseControl> activePowerControlPhaseControls) {
        MutableInt numOfActivePowerControlPstsThatChangedTap = new MutableInt(0);
        for (TransformerPhaseControl phaseControl : activePowerControlPhaseControls) {
            LfBranch controllerBranch = phaseControl.getControllerBranch();
            LfBranch controlledBranch = phaseControl.getControlledBranch();
            Evaluable p = phaseControl.getControlledSide() == TwoSides.ONE ? controlledBranch.getP1() : controlledBranch.getP2();
            double pValue = p.eval();
            double halfTargetDeadband = AbstractIncrementalPhaseControlOuterLoop.getHalfTargetDeadband(phaseControl);
            if (!(Math.abs(pValue - phaseControl.getTargetValue()) > halfTargetDeadband)) continue;
            IncrementalContextData.ControllerContext controllerContext = contextData.getControllersContexts().get(controllerBranch.getId());
            double dp = phaseControl.getTargetValue() - pValue;
            double a2p = sensitivityContext.calculateSensitivityFromA2P(controllerBranch, controlledBranch, phaseControl.getControlledSide());
            if (!(Math.abs(a2p) > 1.0E-6)) continue;
            double da = Math.toRadians(dp / a2p);
            this.logger.trace("Controlled branch '{}' active power is {} MW and out of target value {} MW (half deadband={} MW), a phase shift of {}\u00b0 is required", new Object[]{controlledBranch.getId(), pValue * 100.0, phaseControl.getTargetValue() * 100.0, halfTargetDeadband * 100.0, Math.toDegrees(da)});
            PiModel piModel = controllerBranch.getPiModel();
            int oldTapPosition = piModel.getTapPosition();
            Range<Integer> tapPositionRange = piModel.getTapPositionRange();
            piModel.updateTapPositionToReachNewA1(da, Integer.MAX_VALUE, controllerContext.getAllowedDirection()).ifPresent(direction -> {
                controllerContext.updateAllowedDirection((Direction)((Object)direction));
                numOfActivePowerControlPstsThatChangedTap.add(1);
            });
            if (piModel.getTapPosition() == oldTapPosition) continue;
            this.logger.debug("Controller branch '{}' change tap from {} to {} to reach active power target (full range: {})", new Object[]{controllerBranch.getId(), oldTapPosition, piModel.getTapPosition(), tapPositionRange});
        }
        return numOfActivePowerControlPstsThatChangedTap.getValue();
    }

    public static abstract class AbstractSensitivityContext<V extends Enum<V>, E extends Enum<E>> {
        private final List<LfBranch> controllerBranches;
        private final EquationSystem<V, E> equationSystem;
        private final JacobianMatrix<V, E> jacobianMatrix;
        private final int[] controllerBranchIndex;
        private DenseMatrix sensitivities;

        protected AbstractSensitivityContext(LfNetwork network, List<LfBranch> controllerBranches, EquationSystem<V, E> equationSystem, JacobianMatrix<V, E> jacobianMatrix) {
            this.controllerBranches = Objects.requireNonNull(controllerBranches);
            this.equationSystem = Objects.requireNonNull(equationSystem);
            this.jacobianMatrix = Objects.requireNonNull(jacobianMatrix);
            this.controllerBranchIndex = LfBranch.createIndex(network, controllerBranches);
        }

        private DenseMatrix getSensitivities() {
            if (this.sensitivities == null) {
                this.sensitivities = this.calculateSensitivityValues(this.controllerBranches, this.controllerBranchIndex, this.equationSystem, this.jacobianMatrix);
            }
            return this.sensitivities;
        }

        public abstract DenseMatrix calculateSensitivityValues(List<LfBranch> var1, int[] var2, EquationSystem<V, E> var3, JacobianMatrix<V, E> var4);

        private EquationTerm<V, E> getP1(LfBranch controlledBranch) {
            return (EquationTerm)controlledBranch.getP1();
        }

        private EquationTerm<V, E> getP2(LfBranch controlledBranch) {
            return (EquationTerm)controlledBranch.getP2();
        }

        protected double calculateSensitivityFromA2S(LfBranch controllerBranch, EquationTerm<V, E> s) {
            return s.calculateSensi(this.getSensitivities(), this.controllerBranchIndex[controllerBranch.getNum()]);
        }

        public double calculateSensitivityFromA2P(LfBranch controllerBranch, LfBranch controlledBranch, TwoSides controlledSide) {
            EquationTerm<V, E> p = controlledSide == TwoSides.ONE ? this.getP1(controlledBranch) : this.getP2(controlledBranch);
            return this.calculateSensitivityFromA2S(controllerBranch, p);
        }
    }
}

