/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop;

import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.lf.outerloop.OuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopContext;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseControlOuterLoop<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters, C extends LoadFlowContext<V, E, P>, O extends OuterLoopContext<V, E, P, C>>
implements OuterLoop<V, E, P, C, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPhaseControlOuterLoop.class);
    private static final String TYPE = "PhaseControl";

    protected AbstractPhaseControlOuterLoop() {
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected static List<LfBranch> getControllerBranches(LfNetwork network) {
        return network.getBranches().stream().filter(branch -> !branch.isDisabled() && branch.isPhaseController() && branch.isConnectedAtBothSides()).collect(Collectors.toList());
    }

    protected static void fixPhaseShifterNecessaryForConnectivity(LfNetwork network, List<LfBranch> controllerBranches) {
        if (!controllerBranches.isEmpty()) {
            List disabledBranches = network.getBranches().stream().filter(LfElement::isDisabled).collect(Collectors.toList());
            for (LfBranch controllerBranch : controllerBranches) {
                TransformerPhaseControl phaseControl = controllerBranch.getPhaseControl().orElseThrow();
                LfBranch controlledBranch = phaseControl.getControlledBranch();
                GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
                connectivity.startTemporaryChanges();
                disabledBranches.stream().filter(b -> b.getBus1() != null && b.getBus2() != null).forEach(connectivity::removeEdge);
                int componentsCountBeforePhaseShifterLoss = connectivity.getNbConnectedComponents();
                if (controlledBranch.getBus1() != null && controlledBranch.getBus2() != null) {
                    connectivity.removeEdge(controlledBranch);
                }
                if (connectivity.getNbConnectedComponents() != componentsCountBeforePhaseShifterLoss) {
                    LOGGER.warn("Phase shifter '{}' control branch '{}' phase but is necessary for connectivity: switch off phase control", (Object)controllerBranch.getId(), (Object)controlledBranch.getId());
                    controllerBranch.setPhaseControlEnabled(false);
                }
                connectivity.undoTemporaryChanges();
            }
        }
    }
}

