/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop;

import com.powsybl.openloadflow.network.AllowedDirection;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;

public class IncrementalContextData {
    private final Map<String, ControllerContext> controllersContexts = new HashMap<String, ControllerContext>();
    private final List<LfBus> candidateControlledBuses;

    public Map<String, ControllerContext> getControllersContexts() {
        return this.controllersContexts;
    }

    public List<LfBus> getCandidateControlledBuses() {
        return this.candidateControlledBuses;
    }

    public IncrementalContextData(LfNetwork network, VoltageControl.Type type) {
        this.candidateControlledBuses = network.getBuses().stream().filter(bus -> bus.isVoltageControlled(type)).collect(Collectors.toList());
    }

    public IncrementalContextData() {
        this.candidateControlledBuses = Collections.emptyList();
    }

    public static List<LfBus> getControlledBuses(List<LfBus> candidateControlledBuses, VoltageControl.Type type) {
        return candidateControlledBuses.stream().filter(bus -> bus.getVoltageControl(type).orElseThrow().getMergeStatus() == VoltageControl.MergeStatus.MAIN).filter(bus -> !bus.getVoltageControl(type).orElseThrow().isDisabled()).collect(Collectors.toList());
    }

    public static <E extends LfElement> List<E> getControllerElements(List<LfBus> candidateControlledBuses, VoltageControl.Type type) {
        return IncrementalContextData.getControlledBuses(candidateControlledBuses, type).stream().flatMap(bus -> bus.getVoltageControl(type).orElseThrow().getMergedControllerElements().stream()).filter(Predicate.not(LfElement::isDisabled)).map(element -> element).collect(Collectors.toList());
    }

    public static final class ControllerContext {
        private final int maxDirectionChange;
        private final MutableInt directionChangeCount = new MutableInt();
        private AllowedDirection allowedDirection = AllowedDirection.BOTH;
        private Direction currentDirection;

        public ControllerContext(int maxDirectionChange) {
            this.maxDirectionChange = maxDirectionChange;
        }

        public AllowedDirection getAllowedDirection() {
            return this.allowedDirection;
        }

        public void updateAllowedDirection(Direction direction) {
            if (this.directionChangeCount.getValue() < this.maxDirectionChange) {
                if (this.currentDirection != null && this.currentDirection != direction) {
                    this.directionChangeCount.increment();
                }
                this.currentDirection = direction;
            } else {
                this.allowedDirection = direction.getAllowedDirection();
            }
        }
    }
}

