/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.LoadFlowParametersOverride;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.OuterLoop;
import com.powsybl.openloadflow.lf.outerloop.config.AbstractAcOuterLoopConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExplicitAcOuterLoopConfig
extends AbstractAcOuterLoopConfig {
    public static final List<String> NAMES = List.of("IncrementalPhaseControl", "DistributedSlack", "IncrementalShuntVoltageControl", "IncrementalTransformerVoltageControl", "VoltageMonitoring", "PhaseControl", "ReactiveLimits", "SecondaryVoltageControl", "ShuntVoltageControl", "SimpleTransformerVoltageControl", "TransformerVoltageControl", "AutomationSystem", "IncrementalTransformerReactivePowerControl", "AreaInterchangeControl");

    private static Optional<AcOuterLoop> createOuterLoop(String name, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LoadFlowParametersOverride loadFlowParametersOverride) {
        return switch (name) {
            case "IncrementalPhaseControl" -> ExplicitAcOuterLoopConfig.createPhaseControlOuterLoop(parameters, OpenLoadFlowParameters.PhaseShifterControlMode.INCREMENTAL);
            case "DistributedSlack" -> ExplicitAcOuterLoopConfig.createDistributedSlackOuterLoop(parameters, parametersExt, loadFlowParametersOverride);
            case "IncrementalShuntVoltageControl" -> ExplicitAcOuterLoopConfig.createShuntVoltageControlOuterLoop(parameters, OpenLoadFlowParameters.ShuntVoltageControlMode.INCREMENTAL_VOLTAGE_CONTROL);
            case "IncrementalTransformerVoltageControl" -> ExplicitAcOuterLoopConfig.createTransformerVoltageControlOuterLoop(parameters, parametersExt.isTransformerVoltageControlUseInitialTapPosition(), OpenLoadFlowParameters.TransformerVoltageControlMode.INCREMENTAL_VOLTAGE_CONTROL, parametersExt.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(), parametersExt.getGeneratorVoltageControlMinNominalVoltage());
            case "VoltageMonitoring" -> ExplicitAcOuterLoopConfig.createMonitoringVoltageOuterLoop(parametersExt);
            case "PhaseControl" -> ExplicitAcOuterLoopConfig.createPhaseControlOuterLoop(parameters, OpenLoadFlowParameters.PhaseShifterControlMode.CONTINUOUS_WITH_DISCRETISATION);
            case "ReactiveLimits" -> ExplicitAcOuterLoopConfig.createReactiveLimitsOuterLoop(parameters, parametersExt);
            case "SecondaryVoltageControl" -> ExplicitAcOuterLoopConfig.createSecondaryVoltageControlOuterLoop(parametersExt);
            case "ShuntVoltageControl" -> ExplicitAcOuterLoopConfig.createShuntVoltageControlOuterLoop(parameters, OpenLoadFlowParameters.ShuntVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL);
            case "SimpleTransformerVoltageControl" -> ExplicitAcOuterLoopConfig.createTransformerVoltageControlOuterLoop(parameters, parametersExt.isTransformerVoltageControlUseInitialTapPosition(), OpenLoadFlowParameters.TransformerVoltageControlMode.WITH_GENERATOR_VOLTAGE_CONTROL, parametersExt.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(), parametersExt.getGeneratorVoltageControlMinNominalVoltage());
            case "TransformerVoltageControl" -> ExplicitAcOuterLoopConfig.createTransformerVoltageControlOuterLoop(parameters, parametersExt.isTransformerVoltageControlUseInitialTapPosition(), OpenLoadFlowParameters.TransformerVoltageControlMode.AFTER_GENERATOR_VOLTAGE_CONTROL, parametersExt.getIncrementalTransformerRatioTapControlOuterLoopMaxTapShift(), parametersExt.getGeneratorVoltageControlMinNominalVoltage());
            case "AutomationSystem" -> ExplicitAcOuterLoopConfig.createAutomationSystemOuterLoop(parametersExt);
            case "IncrementalTransformerReactivePowerControl" -> ExplicitAcOuterLoopConfig.createTransformerReactivePowerControlOuterLoop(parametersExt);
            case "AreaInterchangeControl" -> ExplicitAcOuterLoopConfig.createAreaInterchangeControlOuterLoop(parameters, parametersExt, loadFlowParametersOverride);
            default -> throw new PowsyblException("Unknown outer loop '" + name + "' for AC load flow");
        };
    }

    private static void checkTypeUnicity(List<AcOuterLoop> outerLoops) {
        Map<String, Integer> outerLoopTypesCount = outerLoops.stream().collect(Collectors.toMap(OuterLoop::getType, outerLoop -> 1, Integer::sum));
        for (Map.Entry<String, Integer> e : outerLoopTypesCount.entrySet()) {
            int count = e.getValue();
            if (count <= 1) continue;
            String type = e.getKey();
            throw new PowsyblException("Multiple (" + count + ") outer loops with same type: " + type);
        }
    }

    @Override
    public List<AcOuterLoop> configure(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        return this.configure(parameters, parametersExt, LoadFlowParametersOverride.NO_OVERRIDE);
    }

    @Override
    public List<AcOuterLoop> configure(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LoadFlowParametersOverride loadFlowParametersOverride) {
        List<AcOuterLoop> outerLoops = Objects.requireNonNull(loadFlowParametersOverride.getOuterLoopNames(parametersExt)).stream().flatMap(name -> ExplicitAcOuterLoopConfig.createOuterLoop(name, parameters, parametersExt, loadFlowParametersOverride).stream()).toList();
        ExplicitAcOuterLoopConfig.checkTypeUnicity(outerLoops);
        return ExplicitAcOuterLoopConfig.filterInconsistentOuterLoops(outerLoops);
    }
}

