/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.LoadFlowParametersOverride;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcOuterLoop;
import com.powsybl.openloadflow.lf.outerloop.config.AbstractDcOuterLoopConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExplicitDcOuterLoopConfig
extends AbstractDcOuterLoopConfig {
    public static final List<String> NAMES = List.of("IncrementalPhaseControl", "AreaInterchangeControl");

    private static Optional<DcOuterLoop> createOuterLoop(String name, LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LoadFlowParametersOverride loadFlowParametersOverride) {
        return switch (name) {
            case "IncrementalPhaseControl" -> ExplicitDcOuterLoopConfig.createIncrementalPhaseControlOuterLoop(parameters);
            case "AreaInterchangeControl" -> ExplicitDcOuterLoopConfig.createAreaInterchangeControlOuterLoop(parameters, parametersExt, loadFlowParametersOverride);
            default -> throw new PowsyblException("Unknown outer loop '" + name + "' for DC load flow");
        };
    }

    @Override
    public List<DcOuterLoop> configure(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt) {
        return this.configure(parameters, parametersExt, LoadFlowParametersOverride.NO_OVERRIDE);
    }

    @Override
    public List<DcOuterLoop> configure(LoadFlowParameters parameters, OpenLoadFlowParameters parametersExt, LoadFlowParametersOverride loadFlowParametersOverride) {
        return Objects.requireNonNull(loadFlowParametersOverride.getOuterLoopNames(parametersExt)).stream().flatMap(name -> ExplicitDcOuterLoopConfig.createOuterLoop(name, parameters, parametersExt, loadFlowParametersOverride).stream()).toList();
    }
}

