/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf.outerloop.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.LoadFlowParametersOverride;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.lf.outerloop.OuterLoop;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.commons.compress.utils.Lists;

public interface OuterLoopConfig<O extends OuterLoop<?, ?, ?, ?, ?>> {
    public List<O> configure(LoadFlowParameters var1, OpenLoadFlowParameters var2);

    public List<O> configure(LoadFlowParameters var1, OpenLoadFlowParameters var2, LoadFlowParametersOverride var3);

    public static <C extends OuterLoopConfig<?>> Optional<C> findOuterLoopConfig(Class<C> configClass) {
        ArrayList outerLoopConfigs = Lists.newArrayList(ServiceLoader.load(configClass, configClass.getClassLoader()).iterator());
        if (outerLoopConfigs.isEmpty()) {
            return Optional.empty();
        }
        if (outerLoopConfigs.size() > 1) {
            throw new PowsyblException("Only one outer loop config is expected on class path");
        }
        return Optional.of((OuterLoopConfig)outerLoopConfigs.get(0));
    }
}

