/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.AbstractPropertyBag;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.util.Evaluable;
import java.util.List;
import java.util.Objects;

public abstract class AbstractElement
extends AbstractPropertyBag
implements LfElement {
    protected final LfNetwork network;
    protected int num = -1;
    protected boolean disabled = false;

    protected AbstractElement(LfNetwork network) {
        this.network = Objects.requireNonNull(network);
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.getId());
    }

    @Override
    public String getMainOriginalId() {
        return this.getOriginalIds().get(0);
    }

    @Override
    public int getNum() {
        return this.num;
    }

    @Override
    public void setNum(int num) {
        this.num = num;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled != this.disabled) {
            this.disabled = disabled;
            this.notifyDisable();
        }
    }

    protected void notifyDisable() {
        for (LfNetworkListener listener : this.network.getListeners()) {
            listener.onDisableChange(this, this.disabled);
        }
    }

    @Override
    public LfNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void removeEvaluable(Evaluable evaluable) {
    }

    public String toString() {
        return this.getId();
    }
}

